<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $guarded = [];

    //each category might have subcategories
    public function subcategory() {
        return $this->hasMany('App\SubCategory', 'category_id')->with('childcategory');
    }

    //each category might have subchildcategories
    public function childcategory() {
        return $this->hasMany('App\ChildCategory', 'category_id');
    }

    //each category might have products
    public function products() {
        return $this->hasMany('App\Product', 'category_id');
    }

    // each category might belongs to an user
    public function addedBy()
    {
        return $this->belongsTo('App\User','addedby_id');
    }

    public function editedBy()
    {
        return $this->belongsTo('App\User','editedby_id');
    }

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }

}
