<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    protected $guarded = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'start_date',
        'end_date',
        'last_date_of_reg',
        'created_at',
        'updated_at'
    ];


        // each courses might belongs to an user
        public function addedBy()
        {
            return $this->belongsTo('App\User','addedby_id');
        }

        public function editedBy()
        {
            return $this->belongsTo('App\User','editedby_id');
        }

        //each course might have many courseEvents
        public function courseEvents() {
            return $this->hasMany('App\CourseEvent', 'course_id');
        }

        /**
         * Get the route key for the model.
         *
         * @return string
         */
        public function getRouteKeyName()
        {
            return 'slug';
        }
}
