<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CourseTrainer extends Model
{
    protected $guarded = [];

    // each courses might belongs to an user
    public function addedBy()
    {
        return $this->belongsTo('App\User','addedby_id');
    }

    public function editedBy()
    {
        return $this->belongsTo('App\User','editedby_id');
    }

    // each trainer might have multiple events
    public function courseEvents()
    {
        return $this->hasmany('App\CourseEvent','instructor_id');
    }

}
