<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Category;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = Category::all();
        return view('admin.categories.index',compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.categories.addCategories');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|max:255',
            'description' => 'max:2000',
            'hassubcategory' => 'required|boolean',
            'order' => 'required|integer|max:500',
        ]);


        $category=Category::create([
            'name' => $data['name'],
            'description' => $data['description'] ? $data['description'] : null,
            'hassubcategory' => $data['hassubcategory'],
            'order' => $data['order'],
            'slug' => str_slug($data['name'], '-'),
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $updatedCategory = tap($category)->update([
            'slug' => $category->id . '-' . str_slug($category->name, '-')
        ]);


        return back()->with('success','You have successfully added a category.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        return view('admin.categories.editCategories',compact('category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Category $category)
    {

        $data = $request->validate([
            'name' => 'required|max:255',
            'description' => 'max:2000',
            'hassubcategory' => 'required|boolean',
            'order' => 'required|integer|max:500',
        ]);


        $categories = tap($category)->update([
            'name' => $data['name'],
            'description' => $data['description'] ? $data['description'] : null,
            'hassubcategory' => $data['hassubcategory'],
            'order' => $data['order'],
            'slug' => $category->id . '-' . str_slug($data['name'], '-'),
            'editedby_id' => \Auth::id(),
        ]);

        return redirect()->route('admin.categories')->with('success','You have successfully updated a category.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Category $category)
    {
        if ($category->delete()) {
            return redirect()->route('admin.categories')->with('success','You have successfully deleted a category.');
        }
        return redirect()->back();
    }
}


