<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Course;
use App\CourseSchedule;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $courses = DB::table('courses')->get();
        $courses = Course::all();
        return view('admin.courses.index',compact('courses'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.courses.addCourses');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'nullable|max:255',
            'price' => 'nullable|numeric',
            'featured_image' => 'nullable|image|max:2048',
            'contact_mobile' => 'nullable',
            'contact_email' => 'nullable|email',
            'excerpt' => 'nullable',
            'description' => 'nullable',
            'slug' => 'nullable|alpha_dash|unique:courses',
            'order' => 'integer|max:500',
        ]);

        // Managing Feature Image
        $file = $request->file('featured_image');

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($data['title'], '_').'_'.md5(microtime());

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


        $save_path=public_path('img/courses/feature/');


        if (!file_exists($save_path)) {
            mkdir($save_path, 0777, true);
        }

        $file->move($save_path, $ModifiedFileNameWithExtension);

        // return $data;

        $course = Course::create([
            'title' => $data['title'],
            'price' => isset($data['price']) ? $data['price']: null,
            'image' => $ModifiedFileNameWithExtension,
            'contact_mobile' => isset($data['contact_mobile']) ? $data['contact_mobile']:null,
            'contact_email' => isset($data['contact_email']) ? $data['contact_email']:null,
            'excerpt' => isset($data['excerpt']) ? $data['excerpt']:null,
            'description' => $data['description'],
            'slug' => !is_null($data['slug']) ? $data['slug'] : str_slug($data['title'], '-'),
            'order' => $data['order'],
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $course = tap($course)->update([
            'slug' => str_slug($course->title, '-') . '-' .$course->id,
            'order' => $course->id
        ]);

        return back()->with('success','You have successfully added a course.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Course $course)
    {
        return view('admin.courses.editCourses',compact('course'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Course $course)
    {
        //if has image
        if ($request->hasFile('featured_image')) {
            $data = $request->validate([
                'title' => 'nullable|max:255',
                'price' => 'nullable|numeric',
                'featured_image' => 'nullable|image|max:2048',
                'contact_mobile' => 'nullable',
                'contact_email' => 'nullable|email',
                'excerpt' => 'nullable',
                'description' => 'nullable',
                'slug' => 'nullable|alpha_dash|unique:courses,slug,'.$course->id,
                'order' => 'integer|max:500',
            ]);


            function UnlinkImage($old_image)
            {
                // $old_image = $filepath.$fileName;
                if (file_exists($old_image)) {
                    @unlink($old_image);
                }
            }

            UnlinkImage(public_path('img/courses/feature').'/'.$course->image);

            // Managing Feature Image
            $file = $request->file('featured_image');

            $fileNameWithExtension = $file->getClientOriginalName();

            //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
            $ModifiedFileNameWithoutExtension = str_slug($data['title'], '_').'_'.md5(microtime());

            $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

            $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


            $save_path=public_path('img/courses/feature/');


            if (!file_exists($save_path)) {
                mkdir($save_path, 0777, true);
            }

            $file->move($save_path, $ModifiedFileNameWithExtension);

            $courses = tap($course)->update([
                'title' => $data['title'],
                'price' => isset($data['price']) ? $data['price']:null,
                'image' => $ModifiedFileNameWithExtension,
                'contact_mobile' => isset($data['contact_mobile']) ? $data['contact_mobile']:null,
                'contact_email' => isset($data['contact_email']) ? $data['contact_email']:null,
                'excerpt' => isset($data['excerpt']) ? $data['excerpt']:null,
                'description' => $data['description'],
                'slug' => !is_null($data['slug']) ? $data['slug'] : str_slug($data['title'], '-'),
                'order' => $data['order'],
                'editedby_id' => \Auth::id(),
            ]);
            //end of hasimage
        }

        // If no image
        if (!$request->hasFile('featured_image')) {
            $data = $request->validate([
                'title' => 'nullable|max:255',
                'price' => 'nullable|numeric',
                'contact_mobile' => 'nullable',
                'contact_email' => 'nullable|email',
                'excerpt' => 'nullable',
                'description' => 'nullable',
                'slug' => 'nullable|alpha_dash|unique:courses,slug,'.$course->id,
                'order' => 'integer|max:500',
            ]);

            $courses = tap($course)->update([
                'title' => $data['title'],
                'price' => isset($data['price']) ? $data['price']:null,
                'contact_mobile' => isset($data['contact_mobile']) ? $data['contact_mobile']:null,
                'contact_email' => isset($data['contact_email']) ? $data['contact_email']:null,
                'excerpt' => isset($data['excerpt']) ? $data['excerpt']:null,
                'description' => $data['description'],
                'slug' => !is_null($data['slug']) ? $data['slug'] : str_slug($data['title'], '-'),
                'order' => $data['order'],
                'editedby_id' => \Auth::id(),
            ]);



            //end of hasimage false
        }

        return redirect()->route('admin.courses.index')->with('success','You have successfully updated a course.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Course $course)
    {
        $courseImage = $course->image;
        if ($course->delete()) {
            function UnlinkImage($old_image)
            {
                // $old_image = $filepath.$fileName;
                if (file_exists($old_image)) {
                   @unlink($old_image);
                }
            }
            UnlinkImage(public_path('img/courses/feature/').'/'.$courseImage);

            return redirect()->route('admin.courses.index')->with('success','You have successfully deleted a course.');
        }
        return redirect()->back();
    }
}


