<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Requests\StoreProduct;
use App\Http\Requests\UpdateProduct;
use App\Http\Controllers\Controller;
use App\Category;
use App\SubCategory;
use App\ChildCategory;
use App\Product;
use App\ProductImage;
use App\Brand;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Product::all();
        return view('admin.products.index',compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $categories = Category::all();
        $subcategories = SubCategory::all();
        $subchildcategories = ChildCategory::all();
        $brands = Brand::all();

        return view('admin.products.addProducts',compact('categories','brands','subcategories','subchildcategories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProduct $request)
    {

        // The incoming request is valid...

        // Retrieve the validated input data...
        $data = $request->validated();


        // Add Product Info to Products table
        $product=\App\Product::create([
            'name' => $data['name'],
            'category_id' => $data['category_id'],
            'subcategory_id' => $data['subcategory_id'] == "0" ? NULL : $data['subcategory_id'],
            'childcategory_id' => $data['childcategory_id'] == "0" ? NULL : $data['childcategory_id'],
            'season' => $data['season'],
            'brand' => $data['brand'],
            'hassize' => $data['hassize'],
            'sizes' => rtrim(strtoupper($data['sizes']),','),
            'hascolor' => $data['hascolor'],
            'colors' => rtrim(strtoupper($data['colors']),','),
            'purchase_price' => $data['purchase_price'],
            'sale_price' => $data['sale_price'],
            'discount_amount' => $data['discount_amount'],
            'final_price' => $data['final_price'],
            'profit_amount' => $data['profit_amount'],
            'description' => $data['description'] ? $data['description'] : 'Not Available',
            'order' => $data['order'],
            'slug' => str_slug($data['name'], '-'),
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $product = tap($product)->update([
            'slug' => $product->id . '-' . str_slug($product->name, '-')
        ]);

        // Managing Feature Image
        $file = $request->file('featured_image');

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($data['name'], '_').'_'.md5(microtime());

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


        $img = \Image::make($file->getRealPath());

        $save_path=public_path('images/products/feature/');

        if (!file_exists($save_path)) {
            mkdir($save_path, 0777, true);
        }

        $pathWithFileName = $save_path.$ModifiedFileNameWithExtension;

        $featured_image_resize_width = 360;
        $featured_image_resize_height= 319;

        $img->resize($featured_image_resize_width, $featured_image_resize_height)->save($pathWithFileName,50);

        //If you want to save original size and resized image:

        // $img->save(public_path('uploads/'.$ModifiedFileNameWithExtension))
        // ->resize(320, 240)
        // ->save(public_path('uploads/thumb_'.$ModifiedFileNameWithExtension));


        // Add Feature Image Info to Product_images table
        $productImage=\App\ProductImage::create([
            'product_id' => $product->id,
            'category_id' => $data['category_id'],
            'subcategory_id' => $data['subcategory_id'] == "0" ? NULL : $data['subcategory_id'],
            'childcategory_id' => $data['childcategory_id'] == "0" ? NULL : $data['childcategory_id'],
            'image_type' => 'feature',
            'image_url' => $ModifiedFileNameWithExtension,
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id()
        ]);


        // End of Managing Feature Image

        // Managing Other Images
        foreach (request()->other_images as $other_image) {
        //gererate a increment number;
        @$sl++;

        // Managing Other Image
        $file = $other_image;

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($data['name'], '_').'_'.md5(microtime()).$sl;

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;



        $img = \Image::make($file->getRealPath());

        $save_pathLgImg=public_path('images/products/large/');
        $save_pathSmImg=public_path('images/products/small/');
        $save_pathThImg=public_path('images/products/thumb/');

        if (!file_exists($save_pathLgImg)) {
            mkdir($save_pathLgImg, 0777, true);
        }
        if (!file_exists($save_pathSmImg)) {
            mkdir($save_pathSmImg, 0777, true);
        }
        if (!file_exists($save_pathThImg)) {
            mkdir($save_pathThImg, 0777, true);
        }

        $pathWithFileNameLg = $save_pathLgImg.$ModifiedFileNameWithExtension;
        $pathWithFileNameSm = $save_pathSmImg.$ModifiedFileNameWithExtension;
        $pathWithFileNameTh = $save_pathThImg.$ModifiedFileNameWithExtension;


        //large Image Width & Height
        $lg_width = 1024;
        $lg_height= 910;

        //Small Image Width & Height
        $sm_width= 411;
        $sm_height= 274;

        //Thumb Image Width & Height
        $th_width=100;
        $th_height=67;

        $img->resize($lg_width, $lg_height)->save($pathWithFileNameLg,50)
            ->resize($sm_width, $sm_height)->save($pathWithFileNameSm,50)
            ->resize($th_width, $th_height)->save($pathWithFileNameTh,50);


        //Add Other Image Info to Product_images table
        $otherImages=\App\ProductImage::create([
            'product_id' => $product->id,
            'category_id' => $data['category_id'],
            'subcategory_id' => $data['subcategory_id'] == "0" ? NULL : $data['subcategory_id'],
            'childcategory_id' => $data['childcategory_id'] == "0" ? NULL : $data['childcategory_id'],
            'image_type' => 'other',
            'image_url' => $ModifiedFileNameWithExtension,
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id()
        ]);
        }
        return back()->with('success','You have successfully added a product.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        return $product;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $product)
    {

        $categories = Category::all();
        $subcategories = SubCategory::all();
        $subchildcategories = ChildCategory::all();
        $brands = Brand::all();

        return view('admin.products.editProducts',compact('categories','subchildcategories','brands','subcategories','product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateProduct $request
     * @param  int  $product
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProduct $request, Product $product)
    {

        // The incoming request is valid...

        // Retrieve the validated input data...
        $data = $request->validated();


        $product = tap($product)->update([
            'name' => $data['name'],
            'category_id' => $data['category_id'],
            'subcategory_id' => $data['subcategory_id'] == "0" ? NULL : $data['subcategory_id'],
            'childcategory_id' => $data['childcategory_id'] == "0" ? NULL : $data['childcategory_id'],
            'season' => $data['season'],
            'brand' => $data['brand'],
            'hassize' => $data['hassize'],
            'sizes' => rtrim(strtoupper($data['sizes']),','),
            'hascolor' => $data['hascolor'],
            'colors' => rtrim(strtoupper($data['colors']),','),
            'purchase_price' => $data['purchase_price'],
            'sale_price' => $data['sale_price'],
            'discount_amount' => $data['discount_amount'],
            'final_price' => $data['final_price'],
            'profit_amount' => $data['profit_amount'],
            'description' => $data['description'] ? $data['description'] : 'Not Available',
            'order' => $data['order'],
            'slug' => $product->id . '-' . str_slug($data['name'], '-'),
            'editedby_id' => \Auth::id()
        ]);



        if(request()->featured_image){
            // Managing Feature Image
            $file = request()->featured_image->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $extension = pathinfo($file, PATHINFO_EXTENSION);
            $imageName = str_slug($data['name'],'_') .'_'. time().'.'.request()->featured_image->getClientOriginalExtension();
            request()->featured_image->move(public_path('images\products'), $imageName);

            // Start Resizing
            // open an image file
            $featured_image = \Image::make(public_path('images\products').'\\'.$imageName);

            $featured_image_resize_width = 360;
            $featured_image_resize_height= 319;

            // now you are able to resize the instance
            $featured_image->resize($featured_image_resize_width, $featured_image_resize_height);


            // finally we save the image as a new file
            $featured_image->save(public_path('images\products').'\\'.$featured_image->filename.'_'.$featured_image_resize_width.'x'.$featured_image_resize_height.'.'.$featured_image->extension,50);

            // Add Feature Image Info to Product_images table
            ProductImage::where([['product_id', $product->id],['image_type','feature']])
            ->update([
                'category_id' => $data['category_id'],
                'subcategory_id' => $data['subcategory_id'] == "0" ? NULL : $data['subcategory_id'],
                'image_type' => 'feature',
                'image_url' => $featured_image->basename,
                'editedby_id' => \Auth::id()
            ]);
            // End of Managing Feature Image
        }

        if(request()->other_images){

            // Managing Other Images
            foreach (request()->other_images as $other_image) {
                @$sl++;
                $file = $other_image->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                $extension = pathinfo($file, PATHINFO_EXTENSION);
                $imageName = str_slug($data['name'],'_') .'_'. time().$sl.'.'.$other_image->getClientOriginalExtension();
                $other_image->move(public_path('images\products'), $imageName);

                // Start Resizing

                //Large Image
                $other_image_Large = \Image::make(public_path('images\products').'\\'.$imageName);
                $other_image_Large_width = 1024;
                $other_image_Large_height= 910;
                $other_image_Large->resize($other_image_Large_width, $other_image_Large_height);
                $other_image_Large->save(public_path('images\products\large').'\\'.$other_image_Large->basename,50);

                //Small Image
                $other_image_Small = \Image::make(public_path('images\products').'\\'.$imageName);
                $other_image_Small_width = 411;
                $other_image_Small_height= 274;
                $other_image_Small->resize($other_image_Small_width, $other_image_Small_height);
                $other_image_Small->save(public_path('images\products\small').'\\'.$other_image_Small->basename,50);

                //Thumbnail Image
                $other_image_Thumb = \Image::make(public_path('images\products').'\\'.$imageName);
                $other_image_Thumb_width = 100;
                $other_image_Thumb_height= 67;
                $other_image_Thumb->resize($other_image_Thumb_width, $other_image_Thumb_height);
                $other_image_Thumb->save(public_path('images\products\thumb').'\\'.$other_image_Thumb->basename,50);

                // Add Other Image Info to Product_images table
                ProductImage::where([['product_id', $product->id],['image_type','other']])
                ->update([
                    'category_id' => $data['category_id'],
                    'subcategory_id' => $data['subcategory_id'] == "0" ? NULL : $data['subcategory_id'],
                    'image_type' => 'other',
                    'image_url' => $other_image_Large->basename,
                    'editedby_id' => \Auth::id()
                ]);
            }
        }
        return redirect()->route('admin.products')->with('success','You have successfully updated a product.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Product $product)
    {
        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
               @unlink($old_image);
            }
        }

        $images = ProductImage::where('product_id',$product->id)->get();

        foreach ($images as $image) {
            if($image->image_type == 'feature'){
                UnlinkImage(public_path('images\products').'\\'.$image->image_url);
            }
            if($image->image_type == 'other'){
                UnlinkImage(public_path('images\products\thumb').'\\'.$image->image_url);
                UnlinkImage(public_path('images\products\small').'\\'.$image->image_url);
                UnlinkImage(public_path('images\products\large').'\\'.$image->image_url);
            }
        }


        if ($product->delete()) {
            return redirect()->route('admin.products')->with('success','You have successfully deleted a product.');
        }
        return redirect()->back();
    }
}
