<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Category;
use App\SubCategory;
use App\ChildCategory;

class SubChildCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = Category::all();
        $subcategories = SubCategory::all();
        $childcategories = ChildCategory::all();
        return view('admin.subchildcategories.index',compact('categories','subcategories','childcategories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::where('hassubcategory',true)->get();
        $subcategories = SubCategory::where('haschildcategory',true)->get();
        return view('admin.subchildcategories.addSubChildCategories',compact('categories','subcategories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|max:255',
            'description' => 'max:2000',
            'category_id' => 'required|integer',
            'subcategory_id' => 'required|integer',
            'order' => 'required|integer|max:500',
        ]);


        $childcategory=ChildCategory::create([
            'name' => $data['name'],
            'description' => $data['description'] ? $data['description'] : null,
            'category_id' => $data['category_id'],
            'subcategory_id' => $data['subcategory_id'],
            'order' => $data['order'],
            'slug' => str_slug($data['name'], '-'),
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $updatedChildcategory = tap($childcategory)->update([
            'slug' => $childcategory->id . '-' . str_slug($childcategory->name, '-')
        ]);


        return back()->with('success','You have successfully added a ChildCategory.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(ChildCategory $childcategory)
    {
        $categories = Category::where('hassubcategory',true)->get();
        $subcategories = SubCategory::where('haschildcategory',true)->get();
        return view('admin.subchildcategories.editSubCategories',compact('categories','subcategories','childcategory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ChildCategory $childcategory)
    {
        $data = $request->validate([
            'name' => 'required|max:255',
            'description' => 'max:2000',
            'category_id' => 'required|integer',
            'subcategory_id' => 'required|integer',
            'order' => 'required|integer|max:500',
        ]);


        $childcategory = tap($childcategory)->update([
            'name' => $data['name'],
            'description' => $data['description'] ? $data['description'] : null,
            'category_id' => $data['category_id'],
            'subcategory_id' => $data['subcategory_id'],
            'order' => $data['order'],
            'slug' => $childcategory->id . '-' . str_slug($data['name'], '-'),
            'editedby_id' => \Auth::id(),
        ]);

        return redirect()->route('admin.subchildcategories')->with('success','You have successfully updated a childcategory.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, ChildCategory $childcategory)
    {
        if ($childcategory->delete()) {
            return redirect()->route('admin.subchildcategories')->with('success','You have successfully deleted a childcategory.');
        }
        return redirect()->back();
    }
}
