<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Course;
use App\Gallery;
use App\CourseEvent;
use Carbon\Carbon;
use App\ImportantLink;

class IndexController extends Controller
{
    /**
     * Show the application homepage.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // @dump(\App::getLocale());


        // \Artisan::call('storage:link');
        // \Artisan::call('view:clear');
        // \Artisan::call('route:clear');
        // die();

        $upcomingCourseEvents = CourseEvent::whereDate('start_date','>',now())->take(5)->get();
        $currentCourses = Course::all();
        $galleries = Gallery::where('type','affiliated')->simplePaginate(15);
        $importantLinks = ImportantLink::orderBy('priority','asc')->get();

        return view('index',compact('upcomingCourseEvents','currentCourses', 'galleries','importantLinks'));
    }

    public function setLocale(Request $request){

        $data = $request->validate([
            'lang' => 'required|max:2',
        ]);

        \App::setLocale($data['lang']=='en');
        if($data['lang']=='en'){
            return redirect('/');
        }
        if($data['lang']=='bn'){
            return redirect('https://translate.google.com/translate?hl=en&sl=en&tl=bn&u=https%3A%2F%2Ftdlcica.com');
        }
        if($data['lang']=='ja'){
            return redirect('https://translate.google.com/translate?hl=en&sl=en&tl=ja&u=https%3A%2F%2Ftdlcica.com');
        }
    }
}
