<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $guarded = [];

    //each product might have one parent category
    public function category() {
        return $this->belongsTo('App\Category', 'category_id');
    }

    //each product might have one parent subcategory
    public function subcategory() {
        return $this->belongsTo('App\SubCategory', 'subcategory_id');
    }

    //each product might have one parent subcategory
    public function childcategory() {
        return $this->belongsTo('App\ChildCategory', 'childcategory_id');
    }

    // each product might belongs to an user
    public function addedBy()
    {
        return $this->belongsTo('App\User','addedby_id');
    }

    public function editedBy()
    {
        return $this->belongsTo('App\User','editedby_id');
    }

    // each product might have many Product_Sizes
    public function productSizes()
    {
        return $this->hasMany(ProductSize::class,'product_id');
    }


    // each product might have many Product_Sizes
    public function productImages()
    {
        return $this->hasMany(ProductImage::class,'product_id');
    }

    // each product might have many Product_Sizes
    public function featureImage()
    {
        return $this->hasOne(ProductImage::class,'product_id')->where('image_type','feature');
    }

    // each product might have many Product_Colors
    public function productColors()
    {
        return $this->hasMany(ProductSize::class,'product_id');
    }
}
