<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    protected $guarded = [];

    //each subcategory might have one parent
    public function category() {
        return $this->belongsTo('App\Category', 'category_id');
    }

    // each subcategory might belongs to an user
    public function addedBy()
    {
        return $this->belongsTo('App\User','addedby_id');
    }

    public function editedBy()
    {
        return $this->belongsTo('App\User','editedby_id');
    }

    // each subcategory might have multiple childcategory
    public function childcategory()
    {
        return $this->hasmany('App\ChildCategory','subcategory_id')->with('products');
    }
    // each subcategory might have multiple products
    public function products()
    {
        return $this->hasmany('App\Product','subcategory_id');
    }

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }

}
