@extends('layouts.admin.master')

@section('title', 'Edit Category')

@section('subTitle', 'Edit a category as much you need.')



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Edit a Category') }}</div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.categories.update',$category->slug) }}">
                        @method('PUT')
                        @csrf

                        <div class="form-group row">
                            <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Name') }}</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') ? old('name') : $category->name }}" required autofocus>

                                @if ($errors->has('name'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="description" class="col-md-4 col-form-label text-md-right">{{ __('Description') }}</label>

                            <div class="col-md-6">
                                <textarea class="form-control{{ $errors->has('description') ? ' is-invalid' : '' }}" name="description" id="description" rows="2">{{ old('description') ? old('description') : $category->description }}</textarea>

                                @if ($errors->has('description'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="hassubcategory" class="col-md-4 col-form-label text-md-right">{{ __('Has SubCategory') }}</label>

                            <div class="col-md-6">
                                <select id="hassubcategory" class="form-control{{ $errors->has('hassubcategory') ? ' is-invalid' : '' }}" name="hassubcategory" required>
                                    <option value="1" {{ old('hassubcategory') == '1' ? 'selected': $category->hassubcategory == '1' ? 'selected': '' }}>Yes</option>
                                    <option value="0" {{ old('hassubcategory') == '0' ? 'selected': $category->hassubcategory == '0' ? 'selected': '' }}>No</option>
                                </select>

                                @if ($errors->has('hassubcategory'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('hassubcategory') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="order" class="col-md-4 col-form-label text-md-right">{{ __('Order') }}</label>

                            <div class="col-md-6">
                                <input id="order" type="number" class="form-control{{ $errors->has('order') ? ' is-invalid' : '' }}" name="order" value="{{ old('order') ? old('order') : $category->order }}" required>

                                @if ($errors->has('order'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('order') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                        <div class="col-md-4"></div>
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Update') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
