@extends('layouts.admin.master')

@section('title', 'Add New Course Event')

@section('subTitle', 'Add new course events as mush you need.')

@section('button')
	<a href="{{ route('admin.courseEvents.index') }}" class="btn btn-success">View All Course Events</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @if ($message = Session::get('success'))
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <strong>{{ $message }}</strong>
                    </div>
                    @endif

                    @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
                    </div>
                    @endif
                    <form method="POST" action="{{ route('admin.courseEvents.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="course_id" class="col-md-12 col-form-label">{{ __('Select Course') }}</label>

                            <div class="col-md-12">
                                <select id="course_id" class="form-control{{ $errors->has('course_id') ? ' is-invalid' : '' }}" name="course_id" required>
                                    <option selected disabled hidden readonly value="">Choose...</option>
                                    @foreach($courses as $course)
                                    <option value="{{$course->id}}" {{old('course_id') == $course->id ? 'selected' : '' }}>{{$course->title}}</option>
                                    @endforeach
                                </select>

                                @if ($errors->has('course_id'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('course_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="instructor_id" class="col-md-12 col-form-label">{{ __('Select Course Instructor') }}</label>

                            <div class="col-md-12">
                                <select id="instructor_id" class="form-control{{ $errors->has('instructor_id') ? ' is-invalid' : '' }}" name="instructor_id" required>
                                    <option selected disabled hidden readonly value="">Choose...</option>
                                    @foreach($courseTrainers as $courseTrainer)
                                    <option value="{{$courseTrainer->id}}" {{old('instructor_id') == $courseTrainer->id ? 'selected' : '' }}>{{$courseTrainer->name}}</option>
                                    @endforeach
                                </select>

                                @if ($errors->has('instructor_id'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('instructor_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="total_hours" class="col-md-12 col-form-label">{{ __('Total No. of Hours') }}</label>

                            <div class="col-md-12">
                                <input id="total_hours" type="text" class="form-control{{ $errors->has('total_hours') ? ' is-invalid' : '' }}" name="total_hours" value="{{ old('total_hours') }}"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                @if ($errors->has('total_hours'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('total_hours') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="total_seat" class="col-md-12 col-form-label">{{ __('Total No. of Seats') }}</label>

                            <div class="col-md-12">
                                <input id="total_seat" type="text" class="form-control{{ $errors->has('total_seat') ? ' is-invalid' : '' }}" name="total_seat" value="{{ old('total_seat') }}"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                @if ($errors->has('total_seat'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('total_seat') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="total_no_of_class" class="col-md-12 col-form-label">{{ __('Total No. of Class') }}</label>

                            <div class="col-md-12">
                                <input id="total_no_of_class" type="text" class="form-control{{ $errors->has('total_no_of_class') ? ' is-invalid' : '' }}" name="total_no_of_class" value="{{ old('total_no_of_class') }}"  oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" required>
                                @if ($errors->has('total_no_of_class'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('total_no_of_class') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="start_date" class="col-md-12 col-form-label">{{ __('Start Date') }}</label>

                            <div class="col-md-12">
                                <div class="input-group calenderpicker mb-3" id="datetimepicker">
                                        <input data-format="yyyy-MM-dd" placeholder="YYYY-MM-DD" id="start_date" type="text" class="form-control{{ $errors->has('start_date') ? ' is-invalid' : '' }}" name="start_date" value="{{ old('start_date') }}" required>
                                        <div class="input-group-append">
                                            <span class="add-on input-group-text" id="basic-addon2">
                                                <i class="fas fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                </div>
                                @if ($errors->has('start_date'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('start_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="end_date" class="col-md-12 col-form-label">{{ __('End Date') }}</label>

                            <div class="col-md-12">
                                <div class="input-group calenderpicker mb-3" id="datetimepicker">
                                        <input data-format="yyyy-MM-dd" placeholder="YYYY-MM-DD" id="end_date" type="text" class="form-control{{ $errors->has('end_date') ? ' is-invalid' : '' }}" name="end_date" value="{{ old('end_date') }}" required>
                                        <div class="input-group-append">
                                            <span class="add-on input-group-text" id="basic-addon2">
                                                <i class="fas fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                </div>
                                @if ($errors->has('end_date'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('end_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                                <label for="last_date_of_reg" class="col-md-12 col-form-label">{{ __('Last Date of Reg.') }}</label>

                                <div class="col-md-12">
                                    <div class="input-group calenderpicker mb-3" id="datetimepicker">
                                        <input data-format="yyyy-MM-dd" placeholder="YYYY-MM-DD" id="last_date_of_reg" type="text" class="form-control{{ $errors->has('last_date_of_reg') ? ' is-invalid' : '' }}" name="last_date_of_reg" value="{{ old('last_date_of_reg') }}" required>
                                        <div class="input-group-append">
                                            <span class="add-on input-group-text" id="basic-addon2">
                                                <i class="fas fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                    </div>
                                    @if ($errors->has('last_date_of_reg'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('last_date_of_reg') }}</strong>
                                        </span>
                                    @endif
                                </div>
                        </div>

                        <fieldset class="todos_labels scheduler-border">
                            <legend class="scheduler-border">Class Schedule</legend>
                            <div class="repeatable" id="repeatable">
                                @if(old('schedule'))
                                @foreach(old('schedule')['day'] as $count => $countValue)
                                <div class="field-group row">
                                    <div class="col-4">
                                        <label for="schedule-day-{{$count}}">Day</label>
                                        <select id="schedule-day-{{$count}}" class="form-control{{ $errors->has('day') ? ' is-invalid' : '' }}" name="schedule[day][]" required>
                                            <option value="" selected disabled>Select Day</option>
                                            <option value="Sunday" {{ old('schedule')['day'][$count] == 'Sunday' ? 'selected' : ''}}>Sunday</option>
                                            <option value="Monday" {{ old('schedule')['day'][$count] == 'Monday' ? 'selected' : ''}}>Monday</option>
                                            <option value="Tuesday" {{ old('schedule')['day'][$count] == 'Tuesday' ? 'selected' : ''}}>Tuesday</option>
                                            <option value="Wednesday" {{ old('schedule')['day'][$count] == 'Wednesday' ? 'selected' : ''}}>Wednesday</option>
                                            <option value="Thursday" {{ old('schedule')['day'][$count] == 'Thursday' ? 'selected' : ''}}>Thursday</option>
                                            <option value="Friday" {{ old('schedule')['day'][$count] == 'Friday' ? 'selected' : ''}}>Friday</option>
                                            <option value="Saturday" {{ old('schedule')['day'][$count] == 'Saturday' ? 'selected' : ''}}>Saturday</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="start_time_{{$count}}">Start Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[start_time][]" class="form-control" id="start_time_{{$count}}" value="{{old('schedule')['start_time'][$count]}}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <label for="end_time_{{$count}}">End Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[end_time][]" class="form-control" id="end_time_{{$count}}"  value="{{old('schedule')['end_time'][$count]}}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    @if($count>0)
                                    <div class="col-2">
                                        <label for="action">Action</label>
                                        <input type="button" class=" form-control btn btn-danger btn-lg span-2 delete" value="Remove" />
                                    </div>
                                    @endif
                                </div>
                                @endforeach
                                @else
                                <div class="field-group row">
                                    <div class="col-4">
                                        <label for="schedule-day-{?}">Day</label>
                                        <select id="schedule-day-{?}" class="form-control{{ $errors->has('day') ? ' is-invalid' : '' }}" name="schedule[day][]" required>
                                            <option value="" selected disabled>Select Day</option>
                                            <option value="Sunday">Sunday</option>
                                            <option value="Monday">Monday</option>
                                            <option value="Tuesday">Tuesday</option>
                                            <option value="Wednesday">Wednesday</option>
                                            <option value="Thursday">Thursday</option>
                                            <option value="Friday">Friday</option>
                                            <option value="Saturday">Saturday</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="start_time_{?}">Start Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[start_time][]" class="form-control" id="start_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="end_time_{?}">End Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[end_time][]" class="form-control" id="end_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>

                            <div class="form-group" style="text-align:right;">
                                <br>
                                <div class="row">
                                    <div class="col-4"></div>
                                    <div class="col-4">
                                        <input type="button" value="Add More Schedule" class="btn btn-success btn-block add">
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <script type="text/template" id="todos_labels">
                            <div class="field-group row">
                                <div class="col-4">
                                        <label for="schedule-day-{?}">Day</label>
                                        <select id="schedule-day-{?}" class="form-control{{ $errors->has('day') ? ' is-invalid' : '' }}" name="schedule[day][]" required>
                                            <option value="" selected disabled>Select Day</option>
                                            <option value="Sunday">Sunday</option>
                                            <option value="Monday">Monday</option>
                                            <option value="Tuesday">Tuesday</option>
                                            <option value="Wednesday">Wednesday</option>
                                            <option value="Thursday">Thursday</option>
                                            <option value="Friday">Friday</option>
                                            <option value="Saturday">Saturday</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="start_time_{?}">Start Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[start_time][]" class="form-control" id="start_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="end_time_{?}">End Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[end_time][]" class="form-control" id="end_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="action">Action</label>
                                        <input type="button" class=" form-control btn btn-danger btn-lg span-2 delete" value="Remove" />
                                    </div>
                            </div>
                        </script>

                        <div class="form-group" style="display:hidden;">
                            <label for="venue" class="col-md-12 col-form-label">{{ __('Venue') }}</label>

                            <div class="col-md-12">
                                <textarea name="venue" id="venue" class="form-control{{ $errors->has('venue') ? ' is-invalid' : '' }}" rows="2">{{ old('venue') ? old('venue') : 'N/A' }}</textarea>
                                @if ($errors->has('venue'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('venue') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group" style="display:none;">
                                <label for="slug" class="col-md-12 col-form-label text-danger font-weight-bold">{{ __('URL Optional') }} <span class="text-danger">
                                        (Only alphanumeric characters and hyphen is applicable.)
                                    </span></label>

                                <div class="col-md-12">
                                    <input id="slug" type="text" class="form-control is-invalid" name="slug" value="{{ old('slug') }}">

                                    @if ($errors->has('slug'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('slug') }}</strong>
                                        </span>
                                    @endif
                                </div>
                        </div>

                        <div class="form-group" style="display:none;">
                                <label for="order" class="col-md-12 col-form-label">{{ __('Order') }}</label>

                                <div class="col-md-12">
                                    <input id="order" type="number" class="form-control{{ $errors->has('order') ? ' is-invalid' : '' }}" name="order" value="{{ old('order') ? old('order') : 1 }}" required>

                                    @if ($errors->has('order'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('order') }}</strong>
                                        </span>
                                    @endif
                                </div>
                        </div>
                        <div class="form-group mb-0">
                            <div class="col-md-12"></div>
                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-primary">
                                        {{ __('Add Course') }}
                                    </button>
                                </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
