@extends('layouts.admin.master')

@section('title', 'Edit a Course')

@section('subTitle', 'Edit a course as mush you need.')

@section('button')
	<a href="{{ route('admin.courses.index') }}" class="btn btn-success">View All Services</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                        @if ($message = Session::get('success'))
						<div class="alert bg-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
                        @endif
						@if (count($errors) > 0)
						<div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
						</div>
						@endif
                        <form method="POST" action="{{ route('admin.courses.update',$course->slug) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="title" class="col-md-12 col-form-label">{{ __('Title') }}</label>

                                <div class="col-md-12">
                                    <input id="title" type="text" class="form-control{{ $errors->has('title') ? ' is-invalid' : '' }}" name="title" value="{{ old('title') ? old('title') : $course->title }}" required>

                                    @if ($errors->has('title'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('title') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                    {{--
                            <div class="form-group">
                                <label for="price" class="col-md-12 col-form-label">{{ __('Course Fee') }}</label>

                                <div class="col-md-12">
                                    <input id="price" type="text" class="form-control{{ $errors->has('price') ? ' is-invalid' : '' }}" name="price" value="{{ old('price') ? old('price') : $course->price }}"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                    @if ($errors->has('price'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('price') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                            <div class="form-group">
                                    <label for="contact_mobile" class="col-md-12 col-form-label text-md-left">{{ __('Contact Mobile No.') }}</label>

                                    <div class="col-md-12">
                                            <input id="contact_mobile" type="text" class="form-control{{ $errors->has('contact_mobile') ? ' is-invalid' : '' }}" name="contact_mobile" value="{{ old('contact_mobile') ? old('contact_mobile') : $course->contact_mobile }}" required>

                                        @if ($errors->has('contact_mobile'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('contact_mobile') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                            </div>

                            <div class="form-group">
                                    <label for="contact_email" class="col-md-12 col-form-label text-md-left">{{ __('Contact Email No.') }}</label>

                                    <div class="col-md-12">
                                            <input id="contact_email" type="text" class="form-control{{ $errors->has('contact_email') ? ' is-invalid' : '' }}" name="contact_email" value="{{ old('contact_email') ? old('contact_email') : $course->contact_email }}" required>

                                        @if ($errors->has('contact_email'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('contact_email') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                            </div>

                            <div class="form-group">
                                <label for="excerpt" class="col-md-12 col-form-label">{{ __('Front Page Short Description (Max Length: 100 characters)') }}</label>

                                <div class="col-md-12">
                                    <textarea class="form-control{{ $errors->has('excerpt') ? ' is-invalid' : '' }}" name="excerpt" maxlength="100" id="excerpt" rows="3">{{ old('excerpt')  ? old('excerpt') : $course->excerpt }}</textarea>

                                    @if ($errors->has('excerpt'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('excerpt') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            --}}

                            <div class="form-group">
                                <label for="description" class="col-md-12 col-form-label">{{ __('Description') }}</label>

                                <div class="col-md-12">
                                    <textarea class="form-control summernote {{ $errors->has('description') ? ' is-invalid' : '' }}" name="description" id="description" rows="3">{{ old('description')  ? old('description') : $course->description }}</textarea>

                                    @if ($errors->has('description'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('description') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="featured_image" class="col-md-12 col-form-label">{!! __('Featured Image <small>(Max Size:1.5MB, Dimensions: 360x319)</small> <span class="text-info">(Leave empty if No image change Needed)</span>') !!}</label>

                                <div class="col-md-12">
                                <div><img src="{{asset('img/courses/feature/'.$course->image)}}" alt="" width="200" height="100"></div>
                                <br>
                                    <input type="file" class="form-control-file{{ $errors->has('featured_image') ? ' is-invalid' : '' }}" id="featured_image" name="featured_image">

                                    @if ($errors->has('featured_image'))
                                        <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                            <strong>{{ $errors->first('featured_image') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group" style="display:none;">
                                    <label for="slug" class="col-md-12 col-form-label text-danger font-weight-bold">{{ __('URL Optional') }} <span class="text-danger">
                                        (Only alphanumeric characters and hyphen is applicable.)
                                    </span></label>

                                    <div class="col-md-12">
                                        <input id="slug" type="text" class="form-control is-invalid" name="slug" value="{{ old('slug')  ? old('slug') : $course->slug }}">

                                        @if ($errors->has('slug'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('slug') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                            </div>

                            <div class="form-group">
                                    <label for="order" class="col-md-12 col-form-label">{{ __('Position') }}</label>

                                    <div class="col-md-12">
                                        <input id="order" type="number" class="form-control{{ $errors->has('order') ? ' is-invalid' : '' }}" name="order" value="{{ old('order')  ? old('order') : $course->order }}" required>

                                        @if ($errors->has('order'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('order') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                            </div>

                            <div class="form-group mb-0">
                                <div class="col-md-12"></div>
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update ') }}
                                        </button>
                                    </div>
                            </div>
                        </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
