@extends('layouts.admin.master')

@section('title', 'Edit a Course')

@section('subTitle', 'Edit a course as mush you need.')

@section('button')
	<a href="{{ route('admin.courses.index') }}" class="btn btn-success">View All Courses</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                        @if ($message = Session::get('success'))
						<div class="alert bg-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
                        @endif
						@if (count($errors) > 0)
						<div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
						</div>
						@endif
                        <form method="POST" action="{{ route('admin.coursetrainers.update',$courseTrainer->id) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="name" class="col-md-12 col-form-label">{{ __('Trainer Name') }}</label>
                                <div class="col-md-12">
                                    <input id="name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') ? old('name') : $courseTrainer->name }}" required>
                                    @if ($errors->has('name'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group d-none">
                                <label for="mobile" class="col-md-12 col-form-label">{{ __('Trainer Mobile No.') }}</label>
                                <div class="col-md-12">
                                    <input id="mobile" type="text" class="form-control{{ $errors->has('mobile') ? ' is-invalid' : '' }}" name="mobile" value="{{ old('mobile') ? old('mobile') : $courseTrainer->mobile }}">
                                    @if ($errors->has('mobile'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('mobile') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group d-none">
                                <label for="email" class="col-md-12 col-form-label">{{ __('Trainer Email Address') }}</label>
                                <div class="col-md-12">
                                    <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') ? old('email') : $courseTrainer->email }}">
                                    @if ($errors->has('email'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group d-none">
                                <label for="photo" class="col-md-12 col-form-label">{!! __('Featured Image <small>(Max Size:500KB, Dimensions: 512x512)</small> <span class="text-info">(Leave empty if No image change Needed)</span>') !!}</label>

                                <div class="col-md-12">
                                <div><img src="{{asset('img/courses/trainer/'.$courseTrainer->photo)}}" alt="" width="200" height="100"></div>
                                <br>
                                    <input type="file" class="form-control-file{{ $errors->has('photo') ? ' is-invalid' : '' }}" id="photo" name="photo">

                                    @if ($errors->has('photo'))
                                        <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                            <strong>{{ $errors->first('photo') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group mb-0">
                                <div class="col-md-12"></div>
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update Trainer') }}
                                        </button>
                                    </div>
                            </div>
                        </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
