@extends('layouts.admin.master')

@section('title', 'View All Galleries')

@section('subTitle', 'All Galleries Information is Available Here.')

@section('button')
	<a href="{{ route('admin.galleries.create') }}" class="btn btn-success">Add New Gallery Image</a>
@endsection



@section('content')
<div class="row gutters">
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
		<div class="card">
			<div class="card-body">
				@if ($message = Session::get('success'))
				<div class="alert alert-success alert-block">
					<button type="button" class="close" data-dismiss="alert">×</button>
					<strong>{{ $message }}</strong>
				</div>
				@endif
				<div class="table-responsive">
				<table class="table table-bordered table-hover">
					<thead class="thead-default">
						<tr>
							<th>#</th>
							<th>Name</th>
							<th>Type</th>
							<th>Image</th>
							<th>Order</th>
							<th>Actions</th>
						</tr>
					</thead>
					<tbody>
					@if(count($galleries))
						@foreach($galleries as $gallery)
						<tr>
							<th scope="row">{{ $gallery->id }}</th>
							<td>{{ $gallery->title }}</td>
							<td>{{ $gallery->type }}</td>
							<td><img src="{{asset('img/gallery/'.$gallery->type.'/'.$gallery->url)}}" alt="{{ $gallery->slug }}" width="100" height=""></td>
							<td>{{ $gallery->order  }}</td>
							<td class="text-center d-flex justify-content-center">
								<a href="{{route('admin.galleries.edit',$gallery->slug)}}" class="btn btn-warning">Edit</a>
								<form action="{{route('admin.galleries.destroy',$gallery->slug)}}" method="post">
									@csrf
									<input type="hidden" name="_method" value="DELETE">
									<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
								</form>
							</td>
						</tr>
						@endforeach
					@endif
					</tbody>
				</table>
				</div>
			</div>
		</div>
	</div>
</div>




@endsection
