@extends('layouts.admin.master')

@section('title', 'Edit a Important Link')

@section('subTitle', 'Edit a link as much you need.')

@section('button')
	<a href="{{ route('admin.important-links.index') }}" class="btn btn-success">View All Important Links</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                        @if ($message = Session::get('success'))
						<div class="alert bg-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
                        @endif
						@if (count($errors) > 0)
						<div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
						</div>
						@endif
                        <form method="POST" action="{{ route('admin.important-links.update',$importantLink->id) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="title" class="col-md-12 col-form-label">{{ __('Title') }}</label>

                                <div class="col-md-12">
                                    <input id="title" type="text" class="form-control{{ $errors->has('title') ? ' is-invalid' : '' }}" name="title" value="{{ old('title') ? old('title') : $importantLink->title }}" required>

                                    @if ($errors->has('title'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('title') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                             <div class="form-group">
                            <label for="url" class="col-md-12 col-form-label">{{ __('Url') }}</label>

                            <div class="col-md-12">
                                <input id="url" type="text" class="form-control{{ $errors->has('url') ? ' is-invalid' : '' }}" name="url"  value="{{ old('title') ? old('url') : $importantLink->url }}" required>

                                @if ($errors->has('url'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('url') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                         <div class="form-group">
                            <label for="priority" class="col-md-12 col-form-label">{{ __('Position') }}</label>

                            <div class="col-md-12">
                                <input id="priority" type="number" class="form-control{{ $errors->has('priority') ? ' is-invalid' : '' }}" name="priority"  value="{{ old('priority') ? old('priority') : $importantLink->priority }}" required>

                                @if ($errors->has('priority'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('priority') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                            <div class="form-group mb-0">
                                <div class="col-md-12"></div>
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update ') }}
                                        </button>
                                    </div>
                            </div>
                        </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
