@extends('layouts.admin.master')

@section('title', 'View All News')

@section('subTitle', 'All News Information is Available Here.')

@section('button')
	<a href="{{ route('admin.news.create') }}" class="btn btn-success">Add New News</a>
@endsection



@section('content')
						<div class="row gutters">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="card">
									<div class="card-body">
											@if ($message = Session::get('success'))
											<div class="alert alert-success alert-block">
												<button type="button" class="close" data-dismiss="alert">×</button>
												<strong>{{ $message }}</strong>
											</div>
											@endif
										<div class="table-responsive">
											<table class="table table-bordered table-hover">
												<thead class="thead-default">
													<tr>
														<th>#</th>
														<th>Title</th>
														<th>Image</th>
														<th>Short Description</th>
														<th>Actions</th>
													</tr>
												</thead>
												<tbody>
												@if(count($news))
													@foreach($news as $singleNews)
													<tr>
														<th scope="row">{{ $singleNews->id }}</th>
														<td>{{ $singleNews->title }}</td>
														<td><img src="/img/news/{{ $singleNews->image }}" alt="{{ $singleNews->title }}" width="100" height=""></td>
														<td>{{ $singleNews->excerpt }}</td>
														<td class="text-center d-flex justify-content-center">
															<a href="/news/{{ $singleNews->slug }}" class="btn btn-primary">View</a>
															<a href="{{route('admin.news.edit',$singleNews->slug)}}" class="btn btn-warning">Edit</a>
															<form action="{{route('admin.news.destroy',$singleNews->slug)}}" method="post">
																@csrf
																<input type="hidden" name="_method" value="DELETE">
																<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
															</form>
														</td>
													</tr>
													@endforeach
												@endif
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
		@if($flash = session('message'))
			<div id="flash-message" class="alert alert-success" role="alert">
				{{$flash}}
			</div>
	@endif


@endsection
