@extends('layouts.admin.master')

@section('title', 'View All Pages')

@section('subTitle', 'All Pages Information is Available Here.')

@section('button')
	<a href="{{ route('admin.pages.create') }}" class="btn btn-success d-none">Add New Page</a>
@endsection



@section('content')
<div class="row gutters">
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
		<div class="card">
			<div class="card-body">
					@if ($message = Session::get('success'))
					<div class="alert alert-success alert-block">
						<button type="button" class="close" data-dismiss="alert">×</button>
						<strong>{{ $message }}</strong>
					</div>
					@endif
					<div class="table-responsive">
						<table class="table table-bordered table-hover">
							<thead class="thead-default">
								<tr>
									<th>#</th>
									<th>Title</th>
									<th>SubTitle</th>
									<th>Image</th>
									<th>Slug</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
							@if(count($pages))
								@foreach($pages as $product)
								<tr>
									<th scope="row">{{ $product->id }}</th>
									<td>{{ $product->title }}</td>
									<td>{{ $product->subtitle }}</td>
									<td>{!! $product->image ? "<img src=\"/img/pages/$product->image \" alt=\"$product->slug\" width=\"100\" height=\"\">" : 'N/A' !!}</td>
									<td>{{ $product->slug }}</td>
									<td class="text-center d-flex justify-content-center">
										<a href="{{ route('admin.pages.edit',$product->slug) }}" class="btn btn-warning">Edit</a>
										<form  class="d-none"  action="{{ route('admin.pages.destroy',$product->slug) }}" method="post">
											@csrf
											<input type="hidden" name="_method" value="DELETE">
											<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
										</form>
									</td>
								</tr>
								@endforeach
							@endif
							</tbody>
						</table>
					</div>
			</div>
		</div>
	</div>
</div>
@endsection
