@extends('layouts.admin.master')

@section('title', 'View All Products')

@section('subTitle', 'All Products Information includeing SubCategories is Available Here.')

@section('button')
	<a href="{{ route('admin.products.create') }}" class="btn btn-success">Add New Product</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif
						<table class="table table-bordered table-hover table-responsive">
											<thead class="thead-default">
												<tr>
													<th>#</th>
													<th>Name</th>
													<th>Parent Category</th>
													<th>Parent SubCategory</th>
													<th>Brand</th>
													<th>Has Size</th>
													<th>Has Color</th>
													<th>Price</th>
													<th>Order</th>
													<th>Updated By</th>
													<th>Actions</th>
												</tr>
											</thead>
											<tbody>
											@if(count($products))
												@foreach($products as $product)
												<tr>
													<th scope="row">{{ $product->id }}</th>
													<td>{{ $product->name }}</td>
													<td>{{ $product->category_id ? $product->category->name : 'N/A' }}</td>
													<td>{{ $product->subcategory_id ? $product->subcategory->name : 'N/A' }}</td>
													<td>{{ $product->brand ? $product->brand : 'N/A' }}</td>
													<td>{{ $product->hassize ? 'Yes' : 'N/A' }}</td>
													<td>{{ $product->hascolor ? 'Yes' : 'N/A' }}</td>
													<td>{{ $product->final_price}}</td>
													<td>{{ $product->order}}</td>
													<td>{{ $product->editedBy ? $product->editedBy->name : 'N/A' }}</td>
													<td class="text-center d-flex justify-content-center">

														<a href="{{ route('admin.products.show',$product->id) }}" class="btn btn-success">View</a>
														<a href="{{ route('admin.products.edit',$product->id) }}" class="btn btn-warning">Edit</a>
														<form action="{{ route('admin.products.destroy',$product->id) }}" method="post">
															@csrf
															<input type="hidden" name="_method" value="DELETE">
															<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
														</form>
													</td>
												</tr>
												@endforeach
											@endif
											</tbody>
										</table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
