@extends('layouts.frontend.master')

@section('content')
<div class="upcoming-courses">
		<div class="container">
			<h1 class="upcoming-courses-title text-center">{{$pageTitle ? $pageTitle : 'No Title Available'}}</h1>
			<div class="row no-gutters">
				@foreach($courseEvents as $courseEvent)
				<div class="col-md-3 upcoming-col">
					<div class="card mx-auto" style="width:270px;">
						<div class="card-header bg-transparent">
							<div class="flip">
								<div class="front">
									<img src="{{asset('img/courses/feature/'.$courseEvent->course->image)}}" class="img-fluid" alt="{{$courseEvent->course->title}}" />
								</div>
								<div class="back">
									<div>
										<a href="{{route('courseEvents.show',[$courseEvent->course->slug,$courseEvent->id])}}" class="about-button" role="button" aria-pressed="true">View Details</a>
									</div>
								</div>
							</div>
						</div>
						<div class="card-body text-success">
							<h5 class="card-title">
								<a href="{{route('courseEvents.show',[$courseEvent->course->slug,$courseEvent->id])}}" class="course-title">{{$courseEvent->course->title}}</a>
							</h5>
							<span class="short-line"></span>

							<ul class="course-info">
								<li>
									<i class="far fa-calendar"></i>
									{{$courseEvent->start_date->format('d M Y')}} - {{$courseEvent->end_date->format('d M Y')}}
								</li>
								<li>
									<i class="far fa-clock"></i>
									Total Hours : {{$courseEvent->total_hours}}
								</li>
							</ul>
						</div>
						<div class="card-footer bg-transparent">
							<div class="price-block d-flex justify-content-around">
								<span class="price d-none">Tk. {{$courseEvent->course->price}}</span>
								<span class="course-reg-btn"><a href="{{route('seminar.register')}}">Enroll Now</a></span>
							</div>
						</div>
					</div>
				</div>
				@endforeach
			</div>
		</div>
	</div>
@endsection