@extends('layouts.frontend.master')

@section('stylesheet')
<link rel="stylesheet" href="{{ asset('assets/vendor/fancybox/jquery.fancybox.min.css') }}">
@endsection

@section('content')
<div class="gallery">
		<div class="container">
			<h1 class="text-center gallery-title">{{$pageTitle}}</h1>
			<div class="gallaries-wrapper">
				<div class="row testimonials-videos">
						@if($currentRouteName == 'galleries.testimonials')
						{{-- start of video section --}}
							<div class="col-md-4 col-sm-6 col-xs-12 galleries-col">
								<div class="overlay-container">
									<a data-fancybox href="https://www.youtube.com/watch?v=0su778TMvyU" data-caption="How to Learn Japanese Effectively (or any language)">
										<figure class="overlay-image text-center">
											{{-- <img src="http://i3.ytimg.com/vi/0su778TMvyU/maxresdefault.jpg" alt="" class="img-fluid"> --}}
											<img src="/img/0su778TMvyU.webp" alt="How to Learn Japanese Effectively (or any language)" class="img-fluid">
											<figcaption class="overlay">How to Learn Japanese Effectively</figcaption>
										</figure>
									</a>
								</div>
							</div>
							<div class="col-md-4 col-sm-6 col-xs-12 galleries-col">
								<div class="overlay-container">
									<a data-fancybox href="https://www.youtube.com/watch?v=MYiEcPEZS2U" data-caption="Learn Japanese - Learn to Introduce Yourself in Japanese!">
										<figure class="overlay-image text-center">
											{{-- <img src="http://i3.ytimg.com/vi/0su778TMvyU/maxresdefault.jpg" alt="" class="img-fluid"> --}}
											<img src="/img/MYiEcPEZS2U.webp" alt="" class="img-fluid">
											<figcaption class="overlay">Learn to Introduce Yourself in Japanese!</figcaption>
										</figure>
									</a>
								</div>
							</div>
							<div class="col-md-4 col-sm-6 col-xs-12 galleries-col">
								<div class="overlay-container">
									<a data-fancybox href="https://www.youtube.com/watch?v=UBwhpPL27-I" data-caption="Japanese Language Translations">
										<figure class="overlay-image text-center">
											{{-- <img src="http://i3.ytimg.com/vi/0su778TMvyU/maxresdefault.jpg" alt="" class="img-fluid"> --}}
											<img src="/img/UBwhpPL27.webp" alt="" class="img-fluid">
											<figcaption class="overlay">Japanese Language Translations</figcaption>
										</figure>
									</a>
								</div>
							</div>
						{{-- end of video section --}}
						@endif
				</div>
				<div class="row">
					@foreach($galleries as $gallery)
					<div class="col-md-4 col-sm-6 col-xs-12 galleries-col">
						<div class="overlay-container">
							<a data-fancybox="gallery" data-caption="{{$gallery->excerpt}}" href="{{ asset('img/gallery/'.$gallery->type.'/'.$gallery->url) }}">
								<figure class="overlay-image text-center">
									<img src="{{ asset('img/gallery/'.$gallery->type.'/'.$gallery->url) }}" alt="{{$gallery->title}}" class="img-fluid">
									<figcaption class="overlay">{{$gallery->title}}</figcaption>
								</figure>
							</a>
						</div>
					</div>
					@endforeach
				</div>
			</div>
            <div class="text-center" style="display:flex; justify-content:center; margin-top:20px;">
                			{{ $galleries ->links() }}
            </div>
		</div>
</div>
@endsection

@section('script')
<script src="{{ asset('assets/vendor/fancybox/jquery.fancybox.min.js') }}"></script>
@endsection