@extends('layouts.frontend.master')

@section('content')
<div class="contact-location-wrapper">
	<div class="contact-container container">
		<h1 class="contacts-title text-center">
			Upload Your CV
		</h1>
		<div class="row">
			<div class="col-md-8 col-sm-12 col-xs-12 contacts-col">
					<div class="contact-wrapper">
							<h2 class="text-left address-title">Upload CV</h2>
								@if(session()->has('success'))
									<div class="alert alert-danger">
									{{ session()->get('success') }}
									</div>
								@endif
								@if ($errors->any())
									<div class="alert alert-danger">
										<strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
									</div>
								@endif
								<form method="POST" action="/upload-cv" enctype="multipart/form-data">
									@csrf
									<div class="form-group row">
										<label for="name" class="col-md-12 col-form-label text-md-left">{{ __('Name') }}</label>

										<div class="col-md-12">
											<input id="name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') }}" placeholder="Your Full Name" onfocus="this.placeholder=''" onblur="this.placeholder='Your Full Name'" required>

											@if ($errors->has('name'))
												<span class="invalid-feedback" role="alert">
													<strong>{{ $errors->first('name') }}</strong>
												</span>
											@endif
										</div>
									</div>

									<div class="form-row">
										<div class="form-group col-md-6">
											<label for="mobile">Mobile</label>
											<input type="text" class="form-control{{ $errors->has('mobile') ? ' is-invalid' : '' }}" name="mobile" value="{{ old('mobile') }}" id="mobile" placeholder="Mobile No." onfocus="this.placeholder=''" onblur="this.placeholder='Mobile No.'" required>

											@if ($errors->has('mobile'))
											<span class="invalid-feedback" role="alert">
												<strong>{{ $errors->first('mobile') }}</strong>
											</span>
											@endif
										</div>
										<div class="form-group col-md-6">
										  <label for="email">Email</label>
										  <input type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" id="email" name="email" value="{{ old('email') }}"  placeholder="Email Address" onfocus="this.placeholder=''" onblur="this.placeholder='Email Address'" required>

										  @if ($errors->has('email'))
										  <span class="invalid-feedback" role="alert">
											  <strong>{{ $errors->first('email') }}</strong>
										  </span>
										  @endif
										</div>
									  </div>
									<div class="form-group">
										<label for="address">Address</label>
										<textarea class="form-control{{ $errors->has('address') ? ' is-invalid' : '' }}" id="address" name="address" rows="2" required>{{ old('address') }}</textarea>

										@if ($errors->has('address'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ $errors->first('address') }}</strong>
										</span>
										@endif
									</div>
									<div class="form-row">
										<div class="col">
											<label for="subject">Subject</label>
											<input type="text" class="form-control"  name="subject" value="{{ old('subject') }}" placeholder="Subject" onfocus="this.placeholder=''" onblur="this.placeholder='Subject'" required>
											@if ($errors->has('subject'))
											<span class="invalid-feedback" role="alert">
												<strong>{{ $errors->first('subject') }}</strong>
											</span>
											@endif
										</div>
									</div>
									<br>

									<div class="form-group">
										<label for="message">Message</label>
										<textarea class="form-control" id="message" name="message" rows="5">{{ old('message') }}</textarea>
										@if ($errors->has('message'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ $errors->first('message') }}</strong>
										</span>
										@endif
									</div>
									<br>

									<div class="form-group">
										<label for="file">{!! __('Upload CV <small class="text-success">(Max Size:1.5MB, Only: pdf,doc,docx,xls,xlsx)</small>') !!}</label>
										<input type="file" class="form-control-file" id="file" name="file">
										@if ($errors->has('file'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ $errors->first('file') }}</strong>
										</span>
										@endif
									</div>
									<br>

									<button type="submit" class="btn btn-primary">Send</button>
								</form>
					</div>
			</div>
			<div class="col-md-4 col-sm-12 com-xs-12 contacts-col">
				<h3 class="download-cv-title text-center">Down CV Format</h3>
				<p class="download-cv-description">If You don't know our recomended CV format, Please download the recomended CV format by clicking the following button:</p>
				<div class="text-center">
					<a href="/cv-style.xlsx" class="download-button" role="button" aria-pressed="true">Download CV Format</a>
				</div>
			</div>
		</div>



	</div>
</div>
@endsection