<!doctype html>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>Laravel</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Raleway:100,600" rel="stylesheet" type="text/css">

        <!-- Styles -->
        <style>
            html, body {
                background-color: #fff;
                color: #636b6f;
                font-family: 'Raleway', sans-serif;
                font-weight: 100;
                height: 100vh;
                margin: 0;
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 84px;
            }

            .links > a {
                color: #636b6f;
                padding: 0 25px;
                font-size: 12px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 30px;
            }
        </style>
    </head>
    <body>
        <div class="flex-center position-ref full-height">
            @if (Route::has('login'))
                <div class="top-right links">
                    @auth
                        <a href="{{ url('/home') }}">Home</a>
                    @else
                        <a href="{{ route('login') }}">Login</a>
                        <a href="{{ route('register') }}">Register</a>
                    @endauth
                </div>
            @endif

            <div class="content">
                <div class="title m-b-md">
                    Laravel
                </div>
                <div>
                    <form action="" method="POST"  name="content" id="editor">
                        @csrf
                        <div class="form-group">
								<label for="description">Description</label>
								<textarea class="form-control" id="description" name="description"  value="" rows="4"  required>N/A</textarea>
							</div>
                        <style>
                                .ck.ck-editor {
                                    max-width: 800px;
                                }
                                </style>
                        <button type="submit">Submit</button>
                    </form>
                </div>

                <div class="links">
                    <a href="https://laravel.com/docs">Documentation</a>
                    <a href="https://laracasts.com">Laracasts</a>
                    <a href="https://laravel-news.com">News</a>
                    <a href="https://forge.laravel.com">Forge</a>
                    <a href="https://github.com/laravel/laravel">GitHub</a>
                </div>
            </div>
        </div>
        <script>
        var token = document.head.querySelector('meta[name="csrf-token"]');

        if (token) {
            // window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token.content;
            console.log(token.content);

        } else {
            console.error('CSRF token not found: https://laravel.com/docs/csrf#csrf-x-csrf-token');
        }
        </script>
        @include('ckfinder::setup')
        {{-- <script src="{{asset('js/ckeditor5/ckeditor.js')}}"></script> --}}
        <script src="{{asset('js/ckeditor4/ckeditor.js')}}"></script>
        <script>

        if ( typeof CKEDITOR !== 'undefined' ) {
            var options = {
            filebrowserImageBrowseUrl: "/laravel-filemanager?type=Images&_token={token.content}",
            filebrowserImageUploadUrl: "/laravel-filemanager/upload?type=Images&_token={token.content}",
            filebrowserBrowseUrl: "/laravel-filemanager?type=Files&_token={token.content}",
            filebrowserUploadUrl: "/laravel-filemanager/upload?type=Files&_token={token.content}",
            extraPlugins: "uploadimage,menu,contextmenu,dialog,dialogui,liststyle,panelbutton,floatpanel,colorbutton,font,image2,justify",
            removePlugins: "uploadimage,image",
            toolbarGroups : [
                    { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
                    { name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
                    { name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
                    { name: 'forms', groups: [ 'forms' ] },
                    '/',
                    { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
                    { name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
                    { name: 'links', groups: [ 'links' ] },
                    { name: 'insert', groups: [ 'insert' ] },
                    '/',
                    { name: 'styles', groups: [ 'styles' ] },
                    { name: 'colors', groups: [ 'colors' ] },
                    { name: 'tools', groups: [ 'tools' ] },
                    { name: 'others', groups: [ 'others' ] },
                    { name: 'about', groups: [ 'about' ] }
                ],
	            removeButtons : 'Flash,Iframe,About'

        };
        CKEDITOR.replace('description', options);
		} else {
			document.getElementById( 'description' ).innerHTML =
				'<div class="tip-a tip-a-alert">This sample requires working Internet connection to load CKEditor 4 from CDN.</div>'
		}

        </script>
    </body>
</html>
