<?php $__env->startSection('title', 'Edit a Page'); ?>

<?php $__env->startSection('subTitle', 'Edit a page as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.pages.index')); ?>" class="btn btn-success">View All Pages</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						<?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>

						<?php if(count($errors) > 0): ?>
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li><?php echo e($error); ?></li>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</ul>
						</div>
						<?php endif; ?>
						<form action="<?php echo e(route('admin.pages.update',$page->slug)); ?>" method="POST" enctype="multipart/form-data">
							<?php echo csrf_field(); ?>
							<input type="hidden" name="_method" value="PUT">
							<div class="form-group">
									<label for="title">Page Title</label>
									<input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('title') ? old('title') : $page->title); ?>" required>
								</div>
							<div class="form-group">
								<label for="subtitle">Page SubTitle</label>
								<input type="text" class="form-control" id="subtitle" name="subtitle" value="<?php echo e(old('subtitle') ? old('subtitle') : $page->subtitle); ?>">
							</div>
							<div class="form-group">
								<label for="image">Page feature Photo (Leave empty if No image change Needed)</label>
								<div><img src="/img/pages/<?php echo e($page->image); ?>" alt=""  width="200" height="100"></div>
								<br>
								<input type="file" class="form-control-file" id="image" name="image">
							</div>
							<div class="form-group">
									<label for="description">Description</label>
									<textarea class="form-control" id="description" name="description" rows="4"><?php echo e(old('description') ? old('description') : $page->description); ?></textarea>
							</div>
							<div class="form-group">
								<label for="slug" style="font-weight:700;">Slug <span style="color:#dc3545;">(Any Changes will broke the page)</span></label>
								<input type="text" class="form-control is-invalid" id="slug" name="slug" value="<?php echo e(old('slug') ? old('slug') : $page->slug); ?>">
    						      <div class="invalid-feedback">
                                    URL friendly slug. like: laravel-5-framework. Only alphanumeric characters and hyphen is applicable.
                                  </div>
							</div>
							<div class="form-group">
								<label for="order">Order</label>
								<input type="text" class="form-control" id="order" name="order" value="<?php echo e(old('order') ? old('order') : $page->order); ?>" required>
							</div>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>