

<?php $__env->startSection('title', 'Add New Course Event'); ?>

<?php $__env->startSection('subTitle', 'Add new course events as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.courseEvents.index')); ?>" class="btn btn-success">View All Course Events</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php if($message = Session::get('success')): ?>
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <strong><?php echo e($message); ?></strong>
                    </div>
                    <?php endif; ?>

                    <?php if(count($errors) > 0): ?>
                    <div class="alert alert-danger">
                        <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
                    </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('admin.courseEvents.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="course_id" class="col-md-12 col-form-label"><?php echo e(__('Select Course')); ?></label>

                            <div class="col-md-12">
                                <select id="course_id" class="form-control<?php echo e($errors->has('course_id') ? ' is-invalid' : ''); ?>" name="course_id" required>
                                    <option selected disabled hidden readonly value="">Choose...</option>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($course->id); ?>" <?php echo e(old('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <?php if($errors->has('course_id')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('course_id')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="instructor_id" class="col-md-12 col-form-label"><?php echo e(__('Select Course Instructor')); ?></label>

                            <div class="col-md-12">
                                <select id="instructor_id" class="form-control<?php echo e($errors->has('instructor_id') ? ' is-invalid' : ''); ?>" name="instructor_id" required>
                                    <option selected disabled hidden readonly value="">Choose...</option>
                                    <?php $__currentLoopData = $courseTrainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseTrainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($courseTrainer->id); ?>" <?php echo e(old('instructor_id') == $courseTrainer->id ? 'selected' : ''); ?>><?php echo e($courseTrainer->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <?php if($errors->has('instructor_id')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('instructor_id')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="total_hours" class="col-md-12 col-form-label"><?php echo e(__('Total No. of Hours')); ?></label>

                            <div class="col-md-12">
                                <input id="total_hours" type="text" class="form-control<?php echo e($errors->has('total_hours') ? ' is-invalid' : ''); ?>" name="total_hours" value="<?php echo e(old('total_hours')); ?>"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                <?php if($errors->has('total_hours')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('total_hours')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="total_seat" class="col-md-12 col-form-label"><?php echo e(__('Total No. of Seats')); ?></label>

                            <div class="col-md-12">
                                <input id="total_seat" type="text" class="form-control<?php echo e($errors->has('total_seat') ? ' is-invalid' : ''); ?>" name="total_seat" value="<?php echo e(old('total_seat')); ?>"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                <?php if($errors->has('total_seat')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('total_seat')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="total_no_of_class" class="col-md-12 col-form-label"><?php echo e(__('Total No. of Class')); ?></label>

                            <div class="col-md-12">
                                <input id="total_no_of_class" type="text" class="form-control<?php echo e($errors->has('total_no_of_class') ? ' is-invalid' : ''); ?>" name="total_no_of_class" value="<?php echo e(old('total_no_of_class')); ?>"  oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" required>
                                <?php if($errors->has('total_no_of_class')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('total_no_of_class')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="start_date" class="col-md-12 col-form-label"><?php echo e(__('Start Date')); ?></label>

                            <div class="col-md-12">
                                <div class="input-group calenderpicker mb-3" id="datetimepicker">
                                        <input data-format="yyyy-MM-dd" placeholder="YYYY-MM-DD" id="start_date" type="text" class="form-control<?php echo e($errors->has('start_date') ? ' is-invalid' : ''); ?>" name="start_date" value="<?php echo e(old('start_date')); ?>" required>
                                        <div class="input-group-append">
                                            <span class="add-on input-group-text" id="basic-addon2">
                                                <i class="fas fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                </div>
                                <?php if($errors->has('start_date')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('start_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="end_date" class="col-md-12 col-form-label"><?php echo e(__('End Date')); ?></label>

                            <div class="col-md-12">
                                <div class="input-group calenderpicker mb-3" id="datetimepicker">
                                        <input data-format="yyyy-MM-dd" placeholder="YYYY-MM-DD" id="end_date" type="text" class="form-control<?php echo e($errors->has('end_date') ? ' is-invalid' : ''); ?>" name="end_date" value="<?php echo e(old('end_date')); ?>" required>
                                        <div class="input-group-append">
                                            <span class="add-on input-group-text" id="basic-addon2">
                                                <i class="fas fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                </div>
                                <?php if($errors->has('end_date')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('end_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                                <label for="last_date_of_reg" class="col-md-12 col-form-label"><?php echo e(__('Last Date of Reg.')); ?></label>

                                <div class="col-md-12">
                                    <div class="input-group calenderpicker mb-3" id="datetimepicker">
                                        <input data-format="yyyy-MM-dd" placeholder="YYYY-MM-DD" id="last_date_of_reg" type="text" class="form-control<?php echo e($errors->has('last_date_of_reg') ? ' is-invalid' : ''); ?>" name="last_date_of_reg" value="<?php echo e(old('last_date_of_reg')); ?>" required>
                                        <div class="input-group-append">
                                            <span class="add-on input-group-text" id="basic-addon2">
                                                <i class="fas fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <?php if($errors->has('last_date_of_reg')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('last_date_of_reg')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>

                        <fieldset class="todos_labels scheduler-border">
                            <legend class="scheduler-border">Class Schedule</legend>
                            <div class="repeatable" id="repeatable">
                                <?php if(old('schedule')): ?>
                                <?php $__currentLoopData = old('schedule')['day']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $count => $countValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="field-group row">
                                    <div class="col-4">
                                        <label for="schedule-day-<?php echo e($count); ?>">Day</label>
                                        <select id="schedule-day-<?php echo e($count); ?>" class="form-control<?php echo e($errors->has('day') ? ' is-invalid' : ''); ?>" name="schedule[day][]" required>
                                            <option value="" selected disabled>Select Day</option>
                                            <option value="Sunday" <?php echo e(old('schedule')['day'][$count] == 'Sunday' ? 'selected' : ''); ?>>Sunday</option>
                                            <option value="Monday" <?php echo e(old('schedule')['day'][$count] == 'Monday' ? 'selected' : ''); ?>>Monday</option>
                                            <option value="Tuesday" <?php echo e(old('schedule')['day'][$count] == 'Tuesday' ? 'selected' : ''); ?>>Tuesday</option>
                                            <option value="Wednesday" <?php echo e(old('schedule')['day'][$count] == 'Wednesday' ? 'selected' : ''); ?>>Wednesday</option>
                                            <option value="Thursday" <?php echo e(old('schedule')['day'][$count] == 'Thursday' ? 'selected' : ''); ?>>Thursday</option>
                                            <option value="Friday" <?php echo e(old('schedule')['day'][$count] == 'Friday' ? 'selected' : ''); ?>>Friday</option>
                                            <option value="Saturday" <?php echo e(old('schedule')['day'][$count] == 'Saturday' ? 'selected' : ''); ?>>Saturday</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="start_time_<?php echo e($count); ?>">Start Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[start_time][]" class="form-control" id="start_time_<?php echo e($count); ?>" value="<?php echo e(old('schedule')['start_time'][$count]); ?>" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <label for="end_time_<?php echo e($count); ?>">End Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[end_time][]" class="form-control" id="end_time_<?php echo e($count); ?>"  value="<?php echo e(old('schedule')['end_time'][$count]); ?>" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($count>0): ?>
                                    <div class="col-2">
                                        <label for="action">Action</label>
                                        <input type="button" class=" form-control btn btn-danger btn-lg span-2 delete" value="Remove" />
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <div class="field-group row">
                                    <div class="col-4">
                                        <label for="schedule-day-{?}">Day</label>
                                        <select id="schedule-day-{?}" class="form-control<?php echo e($errors->has('day') ? ' is-invalid' : ''); ?>" name="schedule[day][]" required>
                                            <option value="" selected disabled>Select Day</option>
                                            <option value="Sunday">Sunday</option>
                                            <option value="Monday">Monday</option>
                                            <option value="Tuesday">Tuesday</option>
                                            <option value="Wednesday">Wednesday</option>
                                            <option value="Thursday">Thursday</option>
                                            <option value="Friday">Friday</option>
                                            <option value="Saturday">Saturday</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="start_time_{?}">Start Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[start_time][]" class="form-control" id="start_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="end_time_{?}">End Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[end_time][]" class="form-control" id="end_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="form-group" style="text-align:right;">
                                <br>
                                <div class="row">
                                    <div class="col-4"></div>
                                    <div class="col-4">
                                        <input type="button" value="Add More Schedule" class="btn btn-success btn-block add">
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <script type="text/template" id="todos_labels">
                            <div class="field-group row">
                                <div class="col-4">
                                        <label for="schedule-day-{?}">Day</label>
                                        <select id="schedule-day-{?}" class="form-control<?php echo e($errors->has('day') ? ' is-invalid' : ''); ?>" name="schedule[day][]" required>
                                            <option value="" selected disabled>Select Day</option>
                                            <option value="Sunday">Sunday</option>
                                            <option value="Monday">Monday</option>
                                            <option value="Tuesday">Tuesday</option>
                                            <option value="Wednesday">Wednesday</option>
                                            <option value="Thursday">Thursday</option>
                                            <option value="Friday">Friday</option>
                                            <option value="Saturday">Saturday</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="start_time_{?}">Start Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[start_time][]" class="form-control" id="start_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="end_time_{?}">End Time</label>
                                        <div class="input-group datetimepicker mb-3" id="datetimepicker">
                                            <input data-format="hh:mm" type="text" name="schedule[end_time][]" class="form-control" id="end_time_{?}" required>
                                            <div class="input-group-append">
                                                <span class="add-on input-group-text" id="basic-addon2">
                                                    <i data-time-icon="icon-time" class="fas fa-clock"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="action">Action</label>
                                        <input type="button" class=" form-control btn btn-danger btn-lg span-2 delete" value="Remove" />
                                    </div>
                            </div>
                        </script>

                        <div class="form-group" style="display:hidden;">
                            <label for="venue" class="col-md-12 col-form-label"><?php echo e(__('Venue')); ?></label>

                            <div class="col-md-12">
                                <textarea name="venue" id="venue" class="form-control<?php echo e($errors->has('venue') ? ' is-invalid' : ''); ?>" rows="2"><?php echo e(old('venue') ? old('venue') : 'N/A'); ?></textarea>
                                <?php if($errors->has('venue')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('venue')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group" style="display:none;">
                                <label for="slug" class="col-md-12 col-form-label text-danger font-weight-bold"><?php echo e(__('URL Optional')); ?> <span class="text-danger">
                                        (Only alphanumeric characters and hyphen is applicable.)
                                    </span></label>

                                <div class="col-md-12">
                                    <input id="slug" type="text" class="form-control is-invalid" name="slug" value="<?php echo e(old('slug')); ?>">

                                    <?php if($errors->has('slug')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('slug')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>

                        <div class="form-group" style="display:none;">
                                <label for="order" class="col-md-12 col-form-label"><?php echo e(__('Order')); ?></label>

                                <div class="col-md-12">
                                    <input id="order" type="number" class="form-control<?php echo e($errors->has('order') ? ' is-invalid' : ''); ?>" name="order" value="<?php echo e(old('order') ? old('order') : 1); ?>" required>

                                    <?php if($errors->has('order')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('order')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>
                        <div class="form-group mb-0">
                            <div class="col-md-12"></div>
                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Add Course')); ?>

                                    </button>
                                </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>