<?php $__env->startSection('title', 'Add New Page'); ?>

<?php $__env->startSection('subTitle', 'Add new Page as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.pages.index')); ?>" class="btn btn-success">View All Pages</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>

<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						<?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>

						<?php if(count($errors) > 0): ?>
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li><?php echo e($error); ?></li>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</ul>
						</div>
						<?php endif; ?>
						<form action="<?php echo e(route('admin.pages.store')); ?>" method="POST" enctype="multipart/form-data">
							<?php echo csrf_field(); ?>
							<div class="form-group">
								<label for="title">Page Title</label>
								<input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('title')); ?>" required>
							</div>
							<div class="form-group">
								<label for="subtitle">Page SubTitle</label>
								<input type="text" class="form-control" id="subtitle" name="subtitle" value="<?php echo e(old('subtitle') ? old('subtitle') : 'N/A'); ?>">
							</div>
							<div class="form-group">
								<label for="image">Page Feature Photo (Max Length: 500KB)</label>
								<input type="file" class="form-control-file" id="image" name="image">
							</div>
							<div class="form-group">
								<label for="description">Description</label>
								<textarea class="form-control" id="description" name="description"  value="" rows="4"><?php echo e(old('description') ? old('description') : ''); ?></textarea>
							</div>
							<div class="form-group">
								<label for="slug" style="font-weight:700;">Slug <span style="color:#dc3545;">(Any Changes will broke the page)</span></label>
								<input type="text" class="form-control is-invalid" id="slug" name="slug" value="<?php echo e(old('slug')); ?>">
    						      <div class="invalid-feedback">
                                    URL friendly slug. Only alphanumeric characters and hyphen is applicable.
                                  </div>
							</div>
							<div class="form-group">
								<label for="order">Position</label>
								<input type="number" class="form-control" id="order" name="order" value="<?php echo e(old('order') ? old('order') : '1'); ?>" required>
							</div>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>