

<?php $__env->startSection('title', 'View All Important Links'); ?>

<?php $__env->startSection('subTitle', 'All Important Links Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.important-links.create')); ?>" class="btn btn-success">Add New Important Link</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
					<?php if($message = Session::get('success')): ?>
					<div class="alert alert-success alert-block">
						<button type="button" class="close" data-dismiss="alert">×</button>
						<strong><?php echo e($message); ?></strong>
					</div>
					<?php endif; ?>
					<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead class="thead-default">
								<tr>
									<th>#</th>
									<th>Title</th>
									<th>URL</th>
									<th>Position</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
								<?php if(count($importantLinks)): ?>
									<?php $__currentLoopData = $importantLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<th scope="row"><?php echo e($link->id); ?></th>
										<td><?php echo e($link->title); ?></td>
										<td><?php echo e($link->url); ?></td>
										<td><?php echo e($link->priority); ?></td>
										<td class="text-center d-flex justify-content-center">
											<a href="<?php echo e(route('admin.important-links.edit',$link->id)); ?>" class="btn btn-warning">Edit</a>
											<form action="<?php echo e(route('admin.important-links.destroy',$link->id)); ?>" method="post">
												<?php echo csrf_field(); ?>
												<input type="hidden" name="_method" value="DELETE">
												<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
											</form>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php endif; ?>
							</tbody>
						</table>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>