

<?php $__env->startSection('title', 'View All SubCategories'); ?>

<?php $__env->startSection('subTitle', 'All SubCategories Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.subcategories.create')); ?>" class="btn btn-info">Add New SubCategory</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <!-- <div class="card-header d-flex justify-content-between"><span><?php echo e(__('View all SubCategories')); ?></span> <span><a href="" class="btn btn-success">Add New Category</a></span></div> -->

                <div class="card-body">
						<?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>
						<table class="table table-bordered table-hover table-responsive">
											<thead class="thead-default">
												<tr>
													<th>#</th>
													<th>Name</th>
													<th>Category Name</th>
													<th>Has ChildCategory</th>
													<th>Slug</th>
													<th>Order</th>
													<th>Added By</th>
													<th>Updated By</th>
													<th>Actions</th>
												</tr>
											</thead>
											<tbody>
											<?php if(count($subcategories)): ?>
												<?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<th scope="row"><?php echo e($subcategory->id); ?></th>
													<td><?php echo e($subcategory->name); ?></td>
													<td><?php echo e($subcategory->category ? $subcategory->category->name : 'N/A'); ?></td>
													<td><?php echo e($subcategory->haschildcategory ? 'Yes' : 'No'); ?></td>
													<td><?php echo e($subcategory->slug); ?></td>
													<td><?php echo e($subcategory->order); ?></td>
													<td><?php echo e($subcategory->addedBy ? $subcategory->addedBy->name : 'N/A'); ?></td>
													<td><?php echo e($subcategory->editedBy ? $subcategory->editedBy->name : 'N/A'); ?></td>
													<td class="text-center d-flex justify-content-center">

														<a href="<?php echo e(route('admin.subcategories.edit',$subcategory->slug)); ?>" class="btn btn-warning">Edit</a>
														<form action="<?php echo e(route('admin.subcategories.destroy',$subcategory->slug)); ?>" method="post">
															<?php echo csrf_field(); ?>
															<input type="hidden" name="_method" value="DELETE">
															<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
														</form>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											<?php endif; ?>
											</tbody>
										</table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>