<?php $__env->startSection('title', 'Add New Course Trainer'); ?>

<?php $__env->startSection('subTitle', 'Add new course trainers as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.coursetrainers.index')); ?>" class="btn btn-success">View All Course Trainers</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php if($message = Session::get('success')): ?>
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <strong><?php echo e($message); ?></strong>
                    </div>
                    <?php endif; ?>

                    <?php if(count($errors) > 0): ?>
                    <div class="alert alert-danger">
                        <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
                    </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('admin.coursetrainers.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="form-group">
                            <label for="name" class="col-md-12 col-form-label"><?php echo e(__('Trainer Name')); ?></label>
                            <div class="col-md-12">
                                <input id="name" type="text" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" name="name" value="<?php echo e(old('name')); ?>" required>
                                <?php if($errors->has('name')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('name')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group d-none">
                            <label for="mobile" class="col-md-12 col-form-label"><?php echo e(__('Trainer Mobile No.')); ?></label>
                            <div class="col-md-12">
                                <input id="mobile" type="text" class="form-control<?php echo e($errors->has('mobile') ? ' is-invalid' : ''); ?>" name="mobile" value="<?php echo e(old('mobile')); ?>">
                                <?php if($errors->has('mobile')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('mobile')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group d-none">
                            <label for="email" class="col-md-12 col-form-label"><?php echo e(__('Trainer Email Address')); ?></label>
                            <div class="col-md-12">
                                <input id="email" type="email" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>">
                                <?php if($errors->has('email')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group d-none">
                            <label for="photo" class="col-md-12 col-form-label"><?php echo __('Trainer Photo <small>(Max Size:500KB, Dimensions: 512px x 512px)</small>'); ?></label>

                            <div class="col-md-12">
                                <input type="file" class="form-control-file<?php echo e($errors->has('photo') ? ' is-invalid' : ''); ?>" id="photo" name="photo">

                                <?php if($errors->has('photo')): ?>
                                    <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                        <strong><?php echo e($errors->first('photo')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group mb-0">
                            <div class="col-md-12"></div>
                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Add Trainer')); ?>

                                    </button>
                                </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>