<?php $__env->startSection('content'); ?>
<div class="contact-location-wrapper">
	<div class="contact-container container">
		<h1 class="contacts-title text-center">
			Upload Your CV
		</h1>
		<div class="row">
			<div class="col-md-8 col-sm-12 col-xs-12 contacts-col">
					<div class="contact-wrapper">
							<h2 class="text-left address-title">Upload CV</h2>
								<?php if(session()->has('success')): ?>
									<div class="alert alert-danger">
									<?php echo e(session()->get('success')); ?>

									</div>
								<?php endif; ?>
								<?php if($errors->any()): ?>
									<div class="alert alert-danger">
										<strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
									</div>
								<?php endif; ?>
								<form method="POST" action="/upload-cv" enctype="multipart/form-data">
									<?php echo csrf_field(); ?>
									<div class="form-group row">
										<label for="name" class="col-md-12 col-form-label text-md-left"><?php echo e(__('Name')); ?></label>

										<div class="col-md-12">
											<input id="name" type="text" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" name="name" value="<?php echo e(old('name')); ?>" placeholder="Your Full Name" onfocus="this.placeholder=''" onblur="this.placeholder='Your Full Name'" required>

											<?php if($errors->has('name')): ?>
												<span class="invalid-feedback" role="alert">
													<strong><?php echo e($errors->first('name')); ?></strong>
												</span>
											<?php endif; ?>
										</div>
									</div>

									<div class="form-row">
										<div class="form-group col-md-6">
											<label for="mobile">Mobile</label>
											<input type="text" class="form-control<?php echo e($errors->has('mobile') ? ' is-invalid' : ''); ?>" name="mobile" value="<?php echo e(old('mobile')); ?>" id="mobile" placeholder="Mobile No." onfocus="this.placeholder=''" onblur="this.placeholder='Mobile No.'" required>

											<?php if($errors->has('mobile')): ?>
											<span class="invalid-feedback" role="alert">
												<strong><?php echo e($errors->first('mobile')); ?></strong>
											</span>
											<?php endif; ?>
										</div>
										<div class="form-group col-md-6">
										  <label for="email">Email</label>
										  <input type="email" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" id="email" name="email" value="<?php echo e(old('email')); ?>"  placeholder="Email Address" onfocus="this.placeholder=''" onblur="this.placeholder='Email Address'" required>

										  <?php if($errors->has('email')): ?>
										  <span class="invalid-feedback" role="alert">
											  <strong><?php echo e($errors->first('email')); ?></strong>
										  </span>
										  <?php endif; ?>
										</div>
									  </div>
									<div class="form-group">
										<label for="address">Address</label>
										<textarea class="form-control<?php echo e($errors->has('address') ? ' is-invalid' : ''); ?>" id="address" name="address" rows="2" required><?php echo e(old('address')); ?></textarea>

										<?php if($errors->has('address')): ?>
										<span class="invalid-feedback" role="alert">
											<strong><?php echo e($errors->first('address')); ?></strong>
										</span>
										<?php endif; ?>
									</div>
									<div class="form-row">
										<div class="col">
											<label for="subject">Subject</label>
											<input type="text" class="form-control"  name="subject" value="<?php echo e(old('subject')); ?>" placeholder="Subject" onfocus="this.placeholder=''" onblur="this.placeholder='Subject'" required>
											<?php if($errors->has('subject')): ?>
											<span class="invalid-feedback" role="alert">
												<strong><?php echo e($errors->first('subject')); ?></strong>
											</span>
											<?php endif; ?>
										</div>
									</div>
									<br>

									<div class="form-group">
										<label for="message">Message</label>
										<textarea class="form-control" id="message" name="message" rows="5"><?php echo e(old('message')); ?></textarea>
										<?php if($errors->has('message')): ?>
										<span class="invalid-feedback" role="alert">
											<strong><?php echo e($errors->first('message')); ?></strong>
										</span>
										<?php endif; ?>
									</div>
									<br>

									<div class="form-group">
										<label for="file"><?php echo __('Upload CV <small class="text-success">(Max Size:1.5MB, Only: pdf,doc,docx,xls,xlsx)</small>'); ?></label>
										<input type="file" class="form-control-file" id="file" name="file">
										<?php if($errors->has('file')): ?>
										<span class="invalid-feedback" role="alert">
											<strong><?php echo e($errors->first('file')); ?></strong>
										</span>
										<?php endif; ?>
									</div>
									<br>

									<button type="submit" class="btn btn-primary">Send</button>
								</form>
					</div>
			</div>
			<div class="col-md-4 col-sm-12 com-xs-12 contacts-col">
				<h3 class="download-cv-title text-center">Down CV Format</h3>
				<p class="download-cv-description">If You don't know our recomended CV format, Please download the recomended CV format by clicking the following button:</p>
				<div class="text-center">
					<a href="/cv-style.xlsx" class="download-button" role="button" aria-pressed="true">Download CV Format</a>
				</div>
			</div>
		</div>



	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>