<!doctype html>
<html lang="en">

<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<!-- CSRF Token -->
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

		<link rel="shortcut icon" href="<?php echo e(asset('img/favicon.ico')); ?>" />
		<title><?php echo e(config('app.name')); ?> Admin Dashboard</title>

		<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,700" rel="stylesheet">

		<!-- Common CSS for Admin Panel -->
		<!-- <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/bootstrap.min.css')); ?>" /> -->
		<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/bootstrap-413/css/bootstrap.min.css')); ?>" />
		<!-- <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/icomoon/icomoon.css')); ?>" /> -->
		<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fontawesome-541/css/all.min.css')); ?>" />
		<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/gijgo/css/gijgo.min.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/main.css')); ?>" />
        <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">

	</head>
	<body>

		<!-- BEGIN .app-wrap -->
		<div class="app-wrap">
			<!-- BEGIN .app-heading -->
			<?php echo $__env->make('layouts.admin.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			<!-- END: .app-heading -->
			<!-- BEGIN .app-container -->
			<div class="app-container">

				<!-- BEGIN .app-side -->
				<?php echo $__env->make('layouts.admin.aside', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
				<!-- END: .app-side -->

				<!-- BEGIN .app-main -->
				<div class="app-main">
					<!-- BEGIN .main-heading -->
					<header class="main-heading">
						<div class="container-fluid">
							<div class="row">
								<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
									<div class="page-icon">
									<i class="fas fa-file"></i>
									</div>
									<div class="page-title  d-flex justify-content-between">
										<div>
											<h5><?php echo $__env->yieldContent('title'); ?></h5>
											<h6 class="sub-heading"><?php echo $__env->yieldContent('subTitle'); ?></h6>
										</div>
										<div>
											<?php echo $__env->yieldContent('button'); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</header>
					<!-- END: .main-heading -->
					<!-- BEGIN .main-content -->
					<div class="main-content">

						<?php echo $__env->yieldContent('content'); ?>

					</div>
					<!-- END: .main-content -->
				</div>
				<!-- END: .app-main -->

			</div>
			<!-- END: .app-container -->
			<!-- BEGIN .main-footer -->
			<footer class="main-footer fixed-btm">
				&copy; <?php echo e(date("Y")); ?> <?php echo e(config('app.name')); ?> Admin <?php echo e(date("Y")); ?>.
			</footer>
			<!-- END: .main-footer -->
		</div>
		<!-- END: .app-wrap -->

		<!-- jQuery first, then Tether, then other JS. -->
		<script src="<?php echo e(asset('assets/admin/js/jquery.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/admin/js/tether.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendor/bootstrap-413/js/bootstrap.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendor/unifyMenu/unifyMenu.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendor/onoffcanvas/onoffcanvas.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/admin/js/moment.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/admin/js/jquery.repeatable.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendor/gijgo/js/gijgo.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendor/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js')); ?>"></script>
		<!-- Common JS -->
		<!--<?php if(Request::route()->getName()=='admin.pages.edit'|| Request::route()->getName()=='admin.pages.create'): ?>-->
		<script src="<?php echo e(asset('assets/admin/js/common.js')); ?>"></script>
		<!--<?php else: ?>-->
		<!--<script src="<?php echo e(asset('assets/vendor/ckeditor/ckeditor.js')); ?>"></script>-->
		<!--<?php endif; ?>-->
		<script>
				var token = document.head.querySelector('meta[name="csrf-token"]');

				if (token) {
					// window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token.content;
					console.log(token.content);

				} else {
					console.error('CSRF token not found: https://laravel.com/docs/csrf#csrf-x-csrf-token');
				}
		</script>
		<?php echo $__env->make('ckfinder::setup', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		
		<script>

			$(document).ready(function () {
			// executes when HTML-Document is loaded and DOM is ready

			// time picker
				try {
					$('.datetimepicker').datetimepicker({
						maskInput: true,
						pickDate: false,
						pick12HourFormat: true,
						pickSeconds: false,
    				});
				} catch (error) {

				}

				// 	calender picker
				try {
					$(function() {
						$('.calenderpicker').datetimepicker({
						maskInput: true,
						pickTime: false
						});
					});
				} catch (error) {

				}

				// repeatable
				try {
					$(function() {
					$(".todos_labels .repeatable").repeatable({
						addTrigger: ".todos_labels .add",
						deleteTrigger: ".todos_labels .delete",
						template: "#todos_labels",
						startWith: 1,
						max: 7
					});
				});
				} catch (error) {

				}

				//call when dom updated
				try {
					// Select the node that will be observed for mutations
					var targetNode = document.getElementById('repeatable');

					// Options for the observer (which mutations to observe)
					var config = { attributes: true, childList: true, subtree: true };

					// Callback function to execute when mutations are observed
					var callback = function(mutationsList, observer) {
						for(var mutation of mutationsList) {
							if (mutation.type == 'childList') {
								console.log('A child node has been added or removed.');
								$('.datetimepicker').datetimepicker({
									maskInput: true,
									pickDate: false,
									pick12HourFormat: true,
									pickSeconds: false
								});
							}
							else if (mutation.type == 'attributes') {
								console.log('The ' + mutation.attributeName + ' attribute was modified.');
							}
						}
					};

					// Create an observer instance linked to the callback function
					var observer = new MutationObserver(callback);

					// Start observing the target node for configured mutations
					observer.observe(targetNode, config);

					// Later, you can stop observing
					// observer.disconnect();
				} catch (error) {

				}

			//ckeditor
				try {
					if ( typeof CKEDITOR !== 'undefined' ) {
						var options = {
						filebrowserImageBrowseUrl: "/laravel-filemanager?type=Images&_token={token.content}",
						filebrowserImageUploadUrl: "/laravel-filemanager/upload?type=Images&_token={token.content}",
						filebrowserBrowseUrl: "/laravel-filemanager?type=Files&_token={token.content}",
						filebrowserUploadUrl: "/laravel-filemanager/upload?type=Files&_token={token.content}",
						extraPlugins: "uploadimage,menu,contextmenu,dialog,dialogui,liststyle,panelbutton,floatpanel,colorbutton,font,image2,justify",
						removePlugins: "uploadimage,image",
						toolbarGroups : [
								{ name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
								{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
								{ name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
								{ name: 'forms', groups: [ 'forms' ] },
								'/',
								{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
								{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
								{ name: 'links', groups: [ 'links' ] },
								{ name: 'insert', groups: [ 'insert' ] },
								'/',
								{ name: 'styles', groups: [ 'styles' ] },
								{ name: 'colors', groups: [ 'colors' ] },
								{ name: 'tools', groups: [ 'tools' ] },
								{ name: 'others', groups: [ 'others' ] },
								{ name: 'about', groups: [ 'about' ] }
							],
							removeButtons : 'Flash,Iframe,About'

						};

						CKEDITOR.replace('description', options);
						} else {
							console.log('no ckeditor');

						}
				} catch (error) {

				}
			});
		</script>
	    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
      $('.summernote').summernote({
        placeholder: 'Page Content',
        tabsize: 4,
        height: 100
      });
    </script>
	</body>

</html>