

<?php $__env->startSection('title', 'View All Course Events'); ?>

<?php $__env->startSection('subTitle', 'All Course Events Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.courseEvents.create')); ?>" class="btn btn-success">Add New Course Event</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
						<?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>
						<div class="table-responsive">
							<table class="table table-bordered table-hover">
												<thead class="thead-default">
													<tr>
														<th>#</th>
														<th>Title</th>
														<th>Price</th>
														<th>Start Date</th>
														<th>End Date</th>
														<th>Last Date of Reg.</th>
														<th>Instructor</th>
														<th>Updated By</th>
														<th>Actions</th>
													</tr>
												</thead>
												<tbody>
												<?php if(count($courseEvents)): ?>
													<?php $__currentLoopData = $courseEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseEvent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<th scope="row"><?php echo e($courseEvent->id); ?></th>
														<td><?php echo e($courseEvent->course->title); ?></td>
														<td><?php echo e($courseEvent->course->price); ?></td>
														<td><?php echo e($courseEvent->start_date->format('d M Y')); ?></td>
														<td><?php echo e($courseEvent->end_date->format('d M Y')); ?></td>
														<td><?php echo e($courseEvent->last_date_of_reg->format('d M Y')); ?></td>
														<td><?php echo e($courseEvent->courseTrainer->name); ?></td>
														<td><?php echo e($courseEvent->editedBy ? $courseEvent->editedBy->name : 'N/A'); ?></td>
														<td class="text-center d-flex justify-content-center">
															<a href="<?php echo e(route('courses.show',$courseEvent->id)); ?>" class="btn btn-success">View</a>
															<a href="<?php echo e(route('admin.courseEvents.edit',$courseEvent->id)); ?>" class="btn btn-warning">Edit</a>
															<form action="<?php echo e(route('admin.courseEvents.destroy',$courseEvent->id)); ?>" method="post">
																<?php echo csrf_field(); ?>
																<input type="hidden" name="_method" value="DELETE">
																<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
															</form>
														</td>
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php endif; ?>
												</tbody>
							</table>
						</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>