<?php $__env->startSection('title', 'Add New Image to Gallery'); ?>

<?php $__env->startSection('subTitle', 'Add new images as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.galleries.index')); ?>" class="btn btn-success">View All Galleries</a>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						<?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>

						<?php if(count($errors) > 0): ?>
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li><?php echo e($error); ?></li>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</ul>
						</div>
						<?php endif; ?>
						<form action="<?php echo e(route('admin.galleries.store')); ?>" method="POST" enctype="multipart/form-data">
							<?php echo csrf_field(); ?>
							<div class="form-group">
								<label for="title">Image Title</label>
								<input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('title')); ?>" required>
							</div>
							<div class="form-group">
									<label for="excerpt">Image Caption</label>
									<textarea class="form-control" id="excerpt" name="excerpt" rows="2" required><?php echo e(old('excerpt')); ?></textarea>
							</div>
							<div class="form-group">
									<label for="type">Image Type </label>
									<select class="form-control" id="type" name="type" required>
										<option value="gallery" <?php echo e((old("type") == 'gallery' ? "selected":"")); ?>>Gallery</option>
										<option value="testimonials" <?php echo e((old("type") == 'testimonials' ? "selected":"")); ?>>Testimonial</option>
										<option value="affiliated" <?php echo e((old("type") == 'affiliated' ? "selected":"")); ?>>Affiliated</option>
									</select>
							</div>
							<div class="form-group">
								<label for="image">Image (Max Length: 500KB)</label>
								<input type="file" class="form-control-file" id="image" name="image" required>
							</div>
							<div class="form-group" style="display:none;">
								<label for="order">Position</label>
								<input type="number" class="form-control" id="order" name="order" value="<?php echo e(old('order') ? old('order') : '1'); ?>" required>
							</div>
							<div class="form-group" style="display:none;">
									<label for="slug" class="col-md-12 col-form-label text-danger font-weight-bold"><?php echo e(__('URL Optional')); ?> <span class="text-danger">
											(Only alphanumeric characters and hyphen is applicable.)
										</span></label>

									<div class="col-md-12">
										<input id="slug" type="text" class="form-control is-invalid" name="slug" value="<?php echo e(old('slug')); ?>">

										<?php if($errors->has('slug')): ?>
											<span class="invalid-feedback" role="alert">
												<strong><?php echo e($errors->first('slug')); ?></strong>
											</span>
										<?php endif; ?>
									</div>
							</div>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>